/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiservletframework.bofh;

import com.neptunelabs.fsiframework.collections.Pair;
import com.neptunelabs.fsiframework.helpers.Inet6AddressUtils;
import com.neptunelabs.fsiservletframework.bofh.HostRange;
import com.neptunelabs.fsiservletframework.bofh.RemoteAddress;
import java.net.Inet6Address;

final class IPv6HostRange
extends HostRange {
    private final Pair<Inet6Address, Inet6Address> range;

    public IPv6HostRange(Inet6Address start, Inet6Address end) {
        this.range = new Pair<Inet6Address, Inet6Address>(start, end);
    }

    @Override
    boolean isInRange(RemoteAddress address) {
        if (address.isIPv6Address()) {
            return Inet6AddressUtils.isInRange(address.ipv6address, this.range);
        }
        return false;
    }

    public String toString() {
        return "IPv6 host range from " + this.range.getItem1().getHostAddress() + " - " + this.range.getItem2().getHostAddress();
    }
}

