/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiservletframework.bofh;

import com.neptunelabs.fsiframework.io.FileOperations;
import com.neptunelabs.fsiframework.io.PathCached;
import com.neptunelabs.fsiservletframework.bofh.BOfH;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.List;

final class ListRefresher
extends Thread {
    private volatile boolean stop = false;
    private long interval = 5000L;
    private long xortime = 0L;
    private long xortimelast = 0L;
    private final BOfH bofh;

    public ListRefresher(BOfH bofh) {
        this.bofh = bofh;
    }

    @Override
    public void run() {
        while (!this.stop) {
            if (this.check()) {
                this.bofh.init();
            }
            try {
                Thread.sleep(this.interval);
            }
            catch (InterruptedException e) {
                this.stop = true;
            }
        }
    }

    public void halt() {
        this.stop = true;
        this.interrupt();
    }

    private boolean check() {
        boolean ret = false;
        this.xortime = 0L;
        if (this.bofh.blacklistPath != null && Files.exists(this.bofh.blacklistPath, new LinkOption[0])) {
            try {
                List<PathCached> blackies = FileOperations.listFiles(this.bofh.blacklistPath, "*.txt");
                for (PathCached list : blackies) {
                    this.xortime ^= list.lastModified();
                }
            }
            catch (IOException blackies) {
                // empty catch block
            }
        }
        if (this.bofh.whitelistPath != null && Files.exists(this.bofh.whitelistPath, new LinkOption[0])) {
            try {
                List<PathCached> whities = FileOperations.listFiles(this.bofh.whitelistPath, "*.txt");
                for (PathCached list : whities) {
                    this.xortime ^= list.lastModified();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.xortime != this.xortimelast) {
            ret = true;
        }
        this.xortimelast = this.xortime;
        return ret;
    }
}

