/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiservletframework.bofh;

import com.neptunelabs.fsiframework.helpers.Inet4AddressUtils;
import com.neptunelabs.fsiframework.helpers.Inet6AddressUtils;
import java.net.Inet6Address;

class RemoteAddress {
    final long ipv4long;
    final Inet6Address ipv6address;

    RemoteAddress(String remoteAddress) {
        this.ipv4long = Inet4AddressUtils.stringToLongIP(remoteAddress);
        this.ipv6address = this.ipv4long == 0L ? Inet6AddressUtils.parseInet6AddressString(remoteAddress) : null;
    }

    boolean isIPv4Address() {
        return this.ipv4long != 0L;
    }

    boolean isIPv6Address() {
        return this.ipv6address != null;
    }

    public String toString() {
        if (this.isIPv4Address()) {
            return Inet4AddressUtils.longToStringIP(this.ipv4long);
        }
        return this.ipv6address.getHostAddress();
    }
}

