/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiservletframework.freemarker;

import com.neptunelabs.fsiframework.helpers.FileEventCallback;
import com.neptunelabs.fsiframework.io.FileOperations;
import com.neptunelabs.fsiframework.io.PathCached;
import com.neptunelabs.fsiframework.logging.FSILogger;
import com.neptunelabs.fsiservletframework.freemarker.TemplateType;
import com.neptunelabs.fsiservletframework.utils.ServletFileEventCursor;
import freemarker.cache.FileTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public final class TemplateCache {
    private final FSILogger logger;
    private final Configuration config;
    private final HashMap<String, Template> cache = new HashMap();
    private final HashMap<Path, TemplateType> templateDirectories = new HashMap();
    private final ServletFileEventCursor eventCursor;
    private DirectoryStream.Filter<Path> filefilter = null;

    public TemplateCache(FSILogger logger, Configuration config, ServletFileEventCursor eventCursor) {
        this.logger = logger;
        this.config = config;
        this.eventCursor = eventCursor;
        final PathMatcher matcher = FileSystems.getDefault().getPathMatcher("glob:*.ftl");
        this.filefilter = new DirectoryStream.Filter<Path>(){

            @Override
            public boolean accept(Path entry) throws IOException {
                return matcher.matches(entry.getFileName());
            }
        };
    }

    public void registerTemplates(TemplateType type, Path baseDirectory, boolean monitored) throws IOException {
        if (Files.isReadable(baseDirectory) && !this.templateDirectories.containsKey(baseDirectory)) {
            this.templateDirectories.put(baseDirectory, type);
            this.loadTemplates(type, baseDirectory);
            if (monitored && this.eventCursor != null) {
                FileEventCallback callback = new FileEventCallback(this, "flush", null);
                ArrayList<FileEventCallback> cL = new ArrayList<FileEventCallback>();
                cL.add(callback);
                this.eventCursor.addPathMonitor(baseDirectory, this.filefilter, true, cL);
            }
        } else if (Files.notExists(baseDirectory, new LinkOption[0])) {
            throw new NoSuchFileException(baseDirectory.toString());
        }
    }

    private void loadTemplates(TemplateType type, Path directory) throws IOException {
        File previousTemplateBaseDir = null;
        TemplateLoader templateLoader = this.config.getTemplateLoader();
        if (templateLoader instanceof FileTemplateLoader) {
            previousTemplateBaseDir = ((FileTemplateLoader)templateLoader).baseDir;
        }
        List<PathCached> files = FileOperations.getRecurseDirectoryFiles(directory, this.filefilter);
        for (PathCached file : files) {
            try {
                this.config.setDirectoryForTemplateLoading(file.getParent().toFile());
                Template template = this.config.getTemplate(file.getFileName().toString());
                String cacheKey = type.name() + file.getAbsoluteName().substring(directory.toAbsolutePath().toString().length()).replace(File.separatorChar, '/');
                template.setCustomAttribute("checksum", (Object)template.toString().hashCode());
                this.cache.put(cacheKey, template);
            }
            catch (IOException e) {
                this.logger.logException(e, 1598, file, e.getLocalizedMessage());
            }
        }
        if (previousTemplateBaseDir != null) {
            this.config.setDirectoryForTemplateLoading(previousTemplateBaseDir);
        }
    }

    public Template getTemplate(TemplateType type, String name) throws IOException {
        String cacheKey = type.name() + "/" + name.replace(File.separatorChar, '/');
        Template tpl = this.cache.get(cacheKey);
        if (tpl != null) {
            return tpl;
        }
        throw new NoSuchFileException(name);
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public void flush() {
        this.cache.clear();
        this.config.clearTemplateCache();
        for (Path dir : this.templateDirectories.keySet()) {
            try {
                this.loadTemplates(this.templateDirectories.get(dir), dir);
            }
            catch (IOException iOException) {}
        }
        if (this.logger != null) {
            this.logger.log(1591, new Object[0]);
        }
    }

    public void dispose() {
        this.cache.clear();
        this.templateDirectories.clear();
    }
}

