/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiservletframework.jmx;

import com.neptunelabs.fsiservletframework.jmx.JMXDescription;
import com.neptunelabs.fsiservletframework.jmx.JMXParam;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashMap;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.NotCompliantMBeanException;
import javax.management.StandardMBean;

public class AnnotatedStandardMBean
extends StandardMBean {
    private static final HashMap<String, Class<?>> primitiveClasses;

    public <T> AnnotatedStandardMBean(T impl, Class<T> mbeanInterface) throws NotCompliantMBeanException {
        super(impl, mbeanInterface);
    }

    protected AnnotatedStandardMBean(Class<?> mbeanInterface) throws NotCompliantMBeanException {
        super(mbeanInterface);
    }

    static Class<?> classForName(String name, ClassLoader loader) throws ClassNotFoundException {
        Class<?> c = primitiveClasses.get(name);
        if (c == null) {
            c = Class.forName(name, false, loader);
        }
        return c;
    }

    private static Method methodFor(Class<?> mbeanInterface, MBeanOperationInfo op) {
        MBeanParameterInfo[] params = op.getSignature();
        String[] paramTypes = new String[params.length];
        for (int i = 0; i < params.length; ++i) {
            paramTypes[i] = params[i].getType();
        }
        return AnnotatedStandardMBean.findMethod(mbeanInterface, op.getName(), paramTypes);
    }

    private static Method findMethod(Class<?> mbeanInterface, String name, String ... paramTypes) {
        ClassLoader loader = mbeanInterface.getClassLoader();
        Class[] paramClasses = new Class[paramTypes.length];
        try {
            for (int i = 0; i < paramTypes.length; ++i) {
                paramClasses[i] = AnnotatedStandardMBean.classForName(paramTypes[i], loader);
            }
            return mbeanInterface.getMethod(name, paramClasses);
        }
        catch (SecurityException e) {
            throw new AssertionError((Object)e);
        }
        catch (NoSuchMethodException e) {
            throw new AssertionError((Object)e);
        }
        catch (ClassNotFoundException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static <A extends Annotation> A getParameterAnnotation(Method m, int paramNo, Class<A> annot) {
        for (Annotation a : m.getParameterAnnotations()[paramNo]) {
            if (!annot.isInstance(a)) continue;
            return (A)((Annotation)annot.cast(a));
        }
        return null;
    }

    @Override
    protected String getDescription(MBeanOperationInfo op) {
        JMXDescription d;
        String descr = op.getDescription();
        Method m = AnnotatedStandardMBean.methodFor(this.getMBeanInterface(), op);
        if (m != null && (d = m.getAnnotation(JMXDescription.class)) != null) {
            descr = d.value();
        }
        return descr;
    }

    @Override
    protected String getDescription(MBeanInfo info) {
        String descr = info.getDescription();
        JMXDescription d = this.getMBeanInterface().getAnnotation(JMXDescription.class);
        if (d != null) {
            descr = d.value();
        }
        return descr;
    }

    @Override
    protected String getParameterName(MBeanOperationInfo op, MBeanParameterInfo param, int paramNo) {
        JMXParam pname;
        String name = param.getName();
        Method m = AnnotatedStandardMBean.methodFor(this.getMBeanInterface(), op);
        if (m != null && (pname = AnnotatedStandardMBean.getParameterAnnotation(m, paramNo, JMXParam.class)) != null) {
            name = pname.value();
        }
        return name;
    }

    static {
        Class[] prims;
        primitiveClasses = new HashMap();
        for (Class c : prims = new Class[]{Byte.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE, Character.TYPE, Boolean.TYPE}) {
            primitiveClasses.put(c.getName(), c);
        }
    }
}

