/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiservletframework.jmx;

import com.neptunelabs.fsiframework.logging.FSILogger;
import com.neptunelabs.fsiservletframework.jmx.AnnotatedStandardMBean;
import java.lang.management.ManagementFactory;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public class MBeanUtils {
    public static MBeanServer server = ManagementFactory.getPlatformMBeanServer();

    private MBeanUtils() {
    }

    public static ObjectName registerMBean(FSILogger logger, String regKey, Object object) {
        ObjectName objectName = null;
        if (server != null) {
            try {
                objectName = new ObjectName(regKey);
                if (!server.isRegistered(objectName)) {
                    server.registerMBean(new AnnotatedStandardMBean(object, null), objectName);
                }
            }
            catch (Exception e) {
                logger.logException(e, 1545, e.getLocalizedMessage());
            }
        }
        return objectName;
    }

    public static void unregister(FSILogger logger, ObjectName objectName) {
        if (server != null) {
            try {
                server.unregisterMBean(objectName);
            }
            catch (Exception e) {
                logger.logException(e, 1545, e.getLocalizedMessage());
            }
        }
    }
}

