/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiservletframework.prerequisites;

import com.neptunelabs.fsiframework.io.MemoryManager;
import com.neptunelabs.fsiframework.logging.FSILogger;
import com.neptunelabs.fsiframework.systeminformation.OperatingSystem;
import com.neptunelabs.fsiframework.systeminformation.SystemInformation;
import com.neptunelabs.fsiframework.systeminformation.VMVendor;
import com.neptunelabs.fsiservletframework.prerequisites.JavaEEServer;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletContext;

public final class Prerequisites {
    public static final int CODE_SERVLET_API_MINIMAL = 1;
    public static final int CODE_SERVLET_API_MAXIMAL = 2;
    public static final int CODE_ENCODED_SLASH = 4;
    public static final int CODE_TOTALMEMORY = 8;
    public static final int CODE_SECUREMODE = 16;
    public static final int CODE_SERVLET_CONTAINER = 32;
    public static final int CODE_JVM_MINIMAL = 64;
    public static final int CODE_JVM_MAXIMAL = 128;
    public static final int CODE_OS = 256;
    public static final int CODE_MEMORY_PER_CPU = 512;
    public static final int CODE_MISC = 1024;
    public static final int CODE_LOGHOME = 2048;
    public static final int CODE_VM = 4096;
    public static final int CODE_DATAMODEL = 8192;
    public static final int CODE_CHARSET = 16384;
    public static final int CODE_THREADS = 32768;
    public static final int CODE_MISSING_OR_INVALID_PROPERTY = 65536;
    private final FSILogger logger;
    private final ServletContext context;
    private final SystemInformation sysinfo;
    private final boolean verbose;
    private final long maxOldGenSpace;
    private final double oldGenTotalRatio;
    private int errorServletMinVersion = 24;
    private int errorServletMaxVersion = -1;
    private int warnServletMinVersion = 24;
    private int warnServletMaxVersion = -1;
    private long errorMinMemory = -1L;
    private long warnMinMemory = -1L;
    private long errorMinPerCPUMemory = -1L;
    private int errorMinPerCPUMemoryThreads = 1;
    private long warnMinPerCPUMemory = -1L;
    private int warnMinPerCPUMemoryThreads = 1;
    private boolean errorSecureMode = false;
    private boolean warnSecureMode = false;
    private boolean errorMissingAllowEncodedSlash = false;
    private boolean warnMissingAllowEncodedSlash = false;
    private boolean errorCheckLogHome = false;
    private boolean warnCheckLogHome = false;
    private Charset warnAllowedCharset = null;
    private Charset errorAllowedCharset = null;
    private boolean errorDataModel32 = false;
    private boolean warnDataModel32 = false;
    private int errorMinThreads = -1;
    private int errorMaxThreads = -1;
    private int warnMinThreads = -1;
    private int warnMaxThreads = -1;
    private final Map<JavaEEServer, ServerVersion> positiveJavaServletContainerList = new HashMap<JavaEEServer, ServerVersion>();
    private final List<JavaEEServer> errorJavaServletContainerList = new ArrayList<JavaEEServer>();
    private final List<OperatingSystem> positiveOSList = new ArrayList<OperatingSystem>();
    private final List<OperatingSystem> errorOSList = new ArrayList<OperatingSystem>();
    private final Map<VMVendor, VMVersion> positiveVMList = new HashMap<VMVendor, VMVersion>();
    private final Map<VMVendor, VMVersion> errorVMList = new HashMap<VMVendor, VMVersion>();
    private final List<RequiredProperty> requiredSystemProperties = new ArrayList<RequiredProperty>();

    public Prerequisites(FSILogger logger, ServletContext context, SystemInformation sysinfo, boolean verbose) {
        this.logger = logger;
        this.context = context;
        this.sysinfo = sysinfo;
        this.verbose = verbose;
        MemoryManager memManager = MemoryManager.getInstance();
        this.maxOldGenSpace = memManager.getMaxOldGen();
        this.oldGenTotalRatio = (double)this.maxOldGenSpace / (double)MemoryManager.getTotalHeapSpace();
    }

    public void setServletAPIVersion(Type type, int minVersion, int maxVersion) {
        if (type == Type.WARN) {
            this.warnServletMinVersion = minVersion;
            this.warnServletMaxVersion = maxVersion;
        } else if (type == Type.ERROR) {
            this.warnServletMinVersion = minVersion;
            this.warnServletMaxVersion = maxVersion;
        }
    }

    public void setServletAPIVersion(Type type, float minVersion, float maxVersion) {
        if (type == Type.WARN) {
            this.warnServletMinVersion = (int)(minVersion * 10.0f);
            if (maxVersion != -1.0f) {
                this.warnServletMaxVersion = (int)(maxVersion * 10.0f);
            }
        } else if (type == Type.ERROR) {
            this.errorServletMinVersion = (int)(minVersion * 10.0f);
            if (maxVersion != -1.0f) {
                this.errorServletMaxVersion = (int)(maxVersion * 10.0f);
            }
        }
    }

    public void setServletAPIVersion(Type type, double minVersion, double maxVersion) {
        if (type == Type.WARN) {
            this.warnServletMinVersion = (int)(minVersion * 10.0);
            if (maxVersion != -1.0) {
                this.warnServletMaxVersion = (int)(maxVersion * 10.0);
            }
        } else if (type == Type.ERROR) {
            this.errorServletMinVersion = (int)(minVersion * 10.0);
            if (maxVersion != -1.0) {
                this.errorServletMaxVersion = (int)(maxVersion * 10.0);
            }
        }
    }

    public void setCheckMissingAllowEncodedSlash(Type type, boolean check) {
        if (type == Type.WARN) {
            this.warnMissingAllowEncodedSlash = check;
        } else if (type == Type.ERROR) {
            this.errorMissingAllowEncodedSlash = check;
        }
    }

    public void setRequiredMinMemory(Type type, long minMemory) {
        if (type == Type.WARN) {
            this.warnMinMemory = minMemory;
        } else if (type == Type.ERROR) {
            this.errorMinMemory = minMemory;
        }
    }

    public void setRequiredMinMemoryPerCPU(Type type, long minMemPerCPU, int threads) {
        if (type == Type.WARN) {
            this.warnMinPerCPUMemory = minMemPerCPU;
            this.warnMinPerCPUMemoryThreads = threads;
        } else if (type == Type.ERROR) {
            this.errorMinPerCPUMemory = minMemPerCPU;
            this.errorMinPerCPUMemoryThreads = threads;
        }
    }

    public void setAllowSecureMode(Type type, boolean secmode) {
        if (type == Type.WARN) {
            this.warnSecureMode = secmode;
        } else if (type == Type.ERROR) {
            this.errorSecureMode = secmode;
        }
    }

    public void setAllowedFileEncoding(Type type, Charset charset) {
        if (type == Type.WARN) {
            this.warnAllowedCharset = charset;
        } else if (type == Type.ERROR) {
            this.errorAllowedCharset = charset;
        }
    }

    public void setCheckLogHome(Type type, boolean state) {
        if (type == Type.WARN) {
            this.warnCheckLogHome = state;
        } else if (type == Type.ERROR) {
            this.errorCheckLogHome = state;
        }
    }

    public void setDisallow32bit(Type type, boolean state) {
        if (type == Type.WARN) {
            this.warnDataModel32 = state;
        } else if (type == Type.ERROR) {
            this.errorDataModel32 = state;
        }
    }

    public void setThreadSettings(Type type, int minThreads, int maxThreads) {
        if (type == Type.WARN) {
            this.warnMinThreads = minThreads;
            this.warnMaxThreads = maxThreads;
        } else if (type == Type.ERROR) {
            this.errorMinThreads = minThreads;
            this.errorMaxThreads = maxThreads;
        }
    }

    public void addRequiredSystemProperty(String propertyName, String value, Type type, int logCode) {
        RequiredProperty rp = new RequiredProperty();
        rp.type = type;
        rp.propertyName = propertyName;
        rp.value = value;
        rp.logCode = logCode;
        this.requiredSystemProperties.add(rp);
    }

    public void addPositiveJavaServletContainer(JavaEEServer server, String minVersionStr, String maxVersionStr) {
        ServerVersion sv = new ServerVersion();
        sv.minVersion = Prerequisites.version3ToInt(minVersionStr);
        sv.maxVersion = Prerequisites.version3ToInt(maxVersionStr);
        this.positiveJavaServletContainerList.put(server, sv);
    }

    public void addErrorJavaServletContainer(JavaEEServer server) {
        this.errorJavaServletContainerList.add(server);
    }

    public void addPositiveOperatingSystem(OperatingSystem os) {
        this.positiveOSList.add(os);
    }

    public void addErrorOperatingSystem(OperatingSystem os) {
        this.errorOSList.add(os);
    }

    public void addPositiveVMVendor(VMVendor vm, String minVersionStr, String maxVersionStr) {
        VMVersion vv = new VMVersion();
        vv.minVersionStr = minVersionStr == null ? "" : minVersionStr;
        vv.minVersion = Prerequisites.versionVMToInt(minVersionStr);
        vv.maxVersionStr = maxVersionStr == null ? "" : maxVersionStr;
        vv.maxVersion = Prerequisites.versionVMToInt(maxVersionStr);
        this.positiveVMList.put(vm, vv);
    }

    public void addErrorVMVendor(VMVendor vm, String minVersionStr, String maxVersionStr) {
        VMVersion vv = new VMVersion();
        vv.minVersionStr = minVersionStr == null ? "" : minVersionStr;
        vv.minVersion = Prerequisites.versionVMToInt(minVersionStr);
        vv.maxVersionStr = maxVersionStr == null ? "" : maxVersionStr;
        vv.maxVersion = Prerequisites.versionVMToInt(maxVersionStr);
        this.errorVMList.put(vm, vv);
    }

    public int check(Type type) {
        int code = 0;
        code |= this.checkSecurityManager(type);
        code |= this.checkJVM(type);
        code |= this.checkServletAPIVersion(type);
        code |= this.checkAllowEncodedSlash(type);
        code |= this.checkMemory(type);
        code |= this.checkMemoryPerCPU(type);
        code |= this.checkLogHome(type);
        code |= this.checkOS(type);
        code |= this.checkServletContainer(type);
        code |= this.checkDataWidth(type);
        code |= this.checkAllowedCharset(type);
        code |= this.checkThreads(type);
        return code |= this.checkRequiredSystemProperties(type);
    }

    private int checkSecurityManager(Type type) {
        int result = 0;
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            if (type == Type.WARN && this.warnSecureMode) {
                result = 16;
                if (this.verbose) {
                    this.logger.log(1535, new Object[0]);
                    System.err.println(this.logger.getLogMessage(1505, new Object[0]));
                }
            } else if (type == Type.ERROR && this.errorSecureMode) {
                result = 16;
                if (this.verbose) {
                    this.logger.log(1505, new Object[0]);
                    System.err.println(this.logger.getLogMessage(1505, new Object[0]));
                }
            }
        }
        return result;
    }

    private int checkJVM(Type type) {
        int result;
        block6: {
            VMVendor vmVendor;
            long cVersion;
            String sVersion;
            block5: {
                result = 0;
                sVersion = this.sysinfo.getJVMVersionDetailed();
                cVersion = Prerequisites.versionVMToInt(sVersion);
                vmVendor = this.sysinfo.getVMVendor();
                if (type != Type.WARN) break block5;
                boolean found = false;
                for (Map.Entry<VMVendor, VMVersion> entry : this.positiveVMList.entrySet()) {
                    if (vmVendor != entry.getKey()) continue;
                    found = true;
                    if (cVersion < entry.getValue().minVersion) {
                        result = 64;
                        if (!this.verbose) break;
                        this.logger.log(1548, new Object[]{sVersion, vmVendor, entry.getValue().minVersionStr, entry.getValue().maxVersionStr});
                        break;
                    }
                    if (cVersion < entry.getValue().maxVersion) continue;
                    result = 128;
                    if (!this.verbose) continue;
                    this.logger.log(1548, new Object[]{sVersion, vmVendor, entry.getValue().minVersionStr, entry.getValue().maxVersionStr});
                }
                if (found) break block6;
                result = 4096;
                if (this.verbose) {
                    this.logger.log(1540, new Object[]{vmVendor});
                }
                break block6;
            }
            if (type == Type.ERROR) {
                for (Map.Entry<VMVendor, VMVersion> entry : this.errorVMList.entrySet()) {
                    if (vmVendor != entry.getKey() || cVersion < entry.getValue().minVersion || cVersion >= entry.getValue().maxVersion) continue;
                    result = 4096;
                    if (!this.verbose) break;
                    this.logger.log(1518, new Object[]{sVersion, vmVendor, entry.getValue().minVersionStr, entry.getValue().maxVersionStr});
                    break;
                }
            }
        }
        return result;
    }

    private int checkServletAPIVersion(Type type) {
        int result = 0;
        int servversion = this.context.getMajorVersion() * 10 + this.context.getMinorVersion();
        if (type == Type.WARN) {
            if (this.warnServletMinVersion != -1 && this.warnServletMinVersion > servversion) {
                result = 1;
                if (this.verbose) {
                    this.logger.log(1531, Float.valueOf(servversion / 10), Float.valueOf(this.warnServletMinVersion / 10));
                }
            }
            if (this.warnServletMaxVersion != -1 && this.warnServletMaxVersion < servversion) {
                result = 2;
                if (this.verbose) {
                    this.logger.log(1532, Float.valueOf(servversion / 10), Float.valueOf(this.warnServletMaxVersion / 10));
                }
            }
        } else if (type == Type.ERROR) {
            if (this.errorServletMinVersion != -1 && this.errorServletMinVersion > servversion) {
                result = 1;
                if (this.verbose) {
                    this.logger.log(1501, Float.valueOf(servversion / 10), Float.valueOf(this.errorServletMinVersion / 10));
                }
            }
            if (this.errorServletMaxVersion != -1 && this.errorServletMaxVersion < servversion) {
                result = 2;
                if (this.verbose) {
                    this.logger.log(1502, Float.valueOf(servversion / 10), Float.valueOf(this.errorServletMaxVersion / 10));
                }
            }
        }
        return result;
    }

    private int checkAllowEncodedSlash(Type type) {
        int result = 0;
        boolean isstate = false;
        try {
            isstate = Boolean.valueOf(System.getProperty("org.apache.tomcat.util.buf.UDecoder.ALLOW_ENCODED_SLASH", "false"));
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (type == Type.WARN && this.warnMissingAllowEncodedSlash && !isstate) {
            result = 4;
            if (this.verbose) {
                this.logger.log(1533, new Object[0]);
            }
        } else if (type == Type.ERROR && this.errorMissingAllowEncodedSlash && !isstate) {
            result = 4;
            if (this.verbose) {
                this.logger.log(1503, new Object[0]);
            }
        }
        return result;
    }

    private int checkMemory(Type type) {
        int result = 0;
        if (this.errorMinMemory != -1L && this.maxOldGenSpace < this.errorMinMemory) {
            if (type == Type.ERROR) {
                result = 8;
                if (this.verbose) {
                    long have = (long)((double)this.maxOldGenSpace / this.oldGenTotalRatio / 1024.0 / 1024.0);
                    long required = this.errorMinMemory / 1024L / 1024L;
                    long want = this.warnMinMemory / 1024L / 1024L;
                    int reqGB = this.recommenedXmxSettings();
                    this.logger.log(1504, Long.toString(have), Long.toString(required), Long.toString(want), Integer.toString(reqGB));
                }
            }
        } else if (type == Type.WARN && this.warnMinMemory != -1L && this.maxOldGenSpace < this.warnMinMemory) {
            result = 8;
            if (this.verbose) {
                long have = (long)((double)this.maxOldGenSpace / this.oldGenTotalRatio / 1024.0 / 1024.0);
                long want = this.warnMinMemory / 1024L / 1024L;
                int reqGB = this.recommenedXmxSettings();
                this.logger.log(1534, Long.toString(have), Long.toString(want), Integer.toString(reqGB));
            }
        }
        return result;
    }

    private int checkMemoryPerCPU(Type type) {
        long want;
        long have;
        int result = 0;
        if (type == Type.WARN && this.warnMinPerCPUMemory != -1L && this.warnMinPerCPUMemoryThreads > 0 && this.maxOldGenSpace < this.warnMinPerCPUMemory * (long)this.warnMinPerCPUMemoryThreads) {
            result = 512;
            if (this.verbose) {
                have = this.maxOldGenSpace / 1024L / 1024L / (long)this.warnMinPerCPUMemoryThreads;
                want = this.warnMinPerCPUMemory / 1024L / 1024L;
                int reqGB = this.recommenedXmxSettings();
                this.logger.log(1544, Long.toString(have), Long.toString(want), Integer.toString(reqGB));
            }
        }
        if (type == Type.ERROR && this.errorMinPerCPUMemory != -1L && this.errorMinPerCPUMemoryThreads > 0 && this.maxOldGenSpace < this.errorMinPerCPUMemory * (long)this.errorMinPerCPUMemoryThreads) {
            result = 512;
            if (this.verbose) {
                have = this.maxOldGenSpace / 1024L / 1024L / (long)this.errorMinPerCPUMemoryThreads;
                want = this.warnMinPerCPUMemory / 1024L / 1024L;
                long required = this.errorMinPerCPUMemory / 1024L / 1024L;
                int reqGB = this.recommenedXmxSettings();
                this.logger.log(1514, Long.toString(have), Long.toString(required), Long.toString(want), Integer.toString(reqGB));
            }
        }
        return result;
    }

    private int recommenedXmxSettings() {
        long recomPerCPU = (long)((float)this.warnMinPerCPUMemory / ((float)this.maxOldGenSpace / (float)this.warnMinPerCPUMemoryThreads) * (float)this.maxOldGenSpace / (float)this.oldGenTotalRatio);
        int gbPerCPU = (int)Math.ceil((float)recomPerCPU / 1024.0f / 1024.0f / 1024.0f);
        int gbTotal = (int)Math.ceil((double)this.warnMinMemory / this.oldGenTotalRatio / 1024.0 / 1024.0 / 1024.0);
        return Math.max(gbTotal, gbPerCPU);
    }

    private int checkRequiredSystemProperties(Type type) {
        int result = 0;
        for (RequiredProperty rp : this.requiredSystemProperties) {
            if (rp.type != type) continue;
            String currentValue = System.getProperty(rp.propertyName);
            if (currentValue == null) {
                result = 65536;
                if (rp.logCode <= 0) continue;
                this.logger.log(rp.logCode, new Object[0]);
                continue;
            }
            if (rp.value == null || currentValue.equals(rp.value)) continue;
            result = 65536;
            if (rp.logCode <= 0) continue;
            this.logger.log(rp.logCode, new Object[0]);
        }
        return result;
    }

    private int checkThreads(Type type) {
        int result = 0;
        int threads = this.sysinfo.getProcessors();
        if (type == Type.WARN) {
            if (this.warnMinThreads != -1 && threads < this.warnMinThreads) {
                result = 32768;
                if (this.verbose) {
                    this.logger.log(1542, Long.toString(threads), Long.toString(this.warnMinThreads));
                }
            }
            if (this.warnMaxThreads != -1 && threads > this.warnMaxThreads) {
                result = 32768;
                if (this.verbose) {
                    this.logger.log(1541, Long.toString(threads), Long.toString(this.warnMaxThreads));
                }
            }
        } else if (type == Type.ERROR) {
            if (this.errorMinThreads != -1 && threads < this.errorMinThreads) {
                result = 32768;
                if (this.verbose) {
                    this.logger.log(1512, Long.toString(threads), Long.toString(this.errorMinThreads));
                }
            }
            if (this.errorMaxThreads != -1 && threads > this.errorMaxThreads) {
                result = 32768;
                if (this.verbose) {
                    this.logger.log(1511, Long.toString(threads), Long.toString(this.errorMaxThreads));
                }
            }
        }
        return result;
    }

    private int checkLogHome(Type type) {
        int result = 0;
        boolean chkState = false;
        Path logFile = null;
        String logBase = null;
        if (this.warnCheckLogHome || this.errorCheckLogHome) {
            try {
                String loghome = System.getProperty("log.home");
                String catalinabase = System.getProperty("catalina.base");
                String catalinahome = System.getProperty("catalina.home");
                if (loghome != null && !loghome.equals("")) {
                    logBase = loghome;
                } else if (catalinabase != null && !catalinabase.equals("")) {
                    logBase = catalinabase;
                } else if (catalinahome != null && !catalinahome.equals("")) {
                    logBase = catalinahome;
                }
                if (logBase != null) {
                    logFile = Paths.get(logBase, new String[0]);
                    if (Files.isWritable(logFile)) {
                        chkState = true;
                    } else {
                        logFile = Paths.get(logBase, "logs");
                        if (Files.isWritable(logFile)) {
                            chkState = true;
                        }
                    }
                }
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        if (type == Type.WARN && this.warnCheckLogHome && !chkState) {
            result = 2048;
            if (this.verbose) {
                if (logFile != null) {
                    this.logger.log(1537, logFile);
                } else {
                    this.logger.log(1537, logBase);
                }
            }
        } else if (type == Type.ERROR && this.errorCheckLogHome && !chkState) {
            result = 2048;
            if (this.verbose) {
                if (logFile != null) {
                    this.logger.log(1507, logFile);
                } else {
                    this.logger.log(1507, logBase);
                }
            }
        }
        return result;
    }

    private int checkDataWidth(Type type) {
        int result = 0;
        if (type == Type.WARN && this.warnDataModel32 && !this.sysinfo.is64()) {
            result = 8192;
            if (this.verbose) {
                this.logger.log(1538, new Object[0]);
            }
        } else if (type == Type.ERROR && this.errorDataModel32 && !this.sysinfo.is64()) {
            result = 8192;
            if (this.verbose) {
                this.logger.log(1508, new Object[0]);
            }
        }
        return result;
    }

    private int checkAllowedCharset(Type type) {
        int result = 0;
        String encStr = System.getProperty("file.encoding");
        if (encStr != null) {
            Charset intCharset = Charset.forName(encStr);
            if (type == Type.WARN && this.warnAllowedCharset != null && !intCharset.equals(this.warnAllowedCharset)) {
                result = 16384;
                if (this.verbose) {
                    this.logger.log(1515, new Object[0]);
                }
            } else if (type == Type.ERROR && this.errorAllowedCharset != null && !intCharset.equals(this.errorAllowedCharset)) {
                result = 16384;
                if (this.verbose) {
                    this.logger.log(1516, new Object[0]);
                }
            }
        }
        return result;
    }

    private int checkOS(Type type) {
        int result = 0;
        OperatingSystem os = this.sysinfo.getOperatingSystem();
        if (this.errorOSList.contains((Object)os)) {
            result = 256;
        } else if (!this.positiveOSList.contains((Object)os)) {
            result = 256;
        }
        if (this.verbose && result != 0) {
            if (type == Type.WARN) {
                this.logger.log(1539, this.sysinfo.getOperationSystemString());
            } else if (type == Type.ERROR) {
                this.logger.log(1509, this.sysinfo.getOperationSystemString());
            }
        }
        return result;
    }

    private int checkServletContainer(Type type) {
        int result = 0;
        if (this.positiveJavaServletContainerList.size() > 0 || this.errorJavaServletContainerList.size() > 0) {
            Pattern pat_glassfish;
            Matcher mat_glassfish;
            Pattern pat_tomcat;
            Matcher mat_tomcat;
            boolean found = false;
            String serverinfo = this.context.getServerInfo();
            JavaEEServer serverName = JavaEEServer.Unknown;
            int serverVersion = -1;
            if (!found && (mat_tomcat = (pat_tomcat = Pattern.compile("Stielaugen", 2)).matcher(serverinfo)).find()) {
                serverName = JavaEEServer.Tomcat;
                serverVersion = Prerequisites.version3ToInt("7.0.35");
                found = true;
            }
            if (!found && (mat_tomcat = (pat_tomcat = Pattern.compile("(Tomcat).+(\\d{1,2}\\.\\d{1,2}\\.\\d{1,3})", 2)).matcher(serverinfo)).find()) {
                serverName = JavaEEServer.Tomcat;
                serverVersion = Prerequisites.version3ToInt(mat_tomcat.group(2));
                found = true;
            }
            if (!found && (mat_tomcat = (pat_tomcat = Pattern.compile("(Tomcat).+(\\d{1,2}\\.\\d{1,2})\\-*", 2)).matcher(serverinfo)).find()) {
                serverName = JavaEEServer.Tomcat;
                serverVersion = Prerequisites.version3ToInt(mat_tomcat.group(2) + ".0");
                found = true;
            }
            if (!found && (mat_tomcat = (pat_tomcat = Pattern.compile("jetty.+(\\d{1,2}\\.\\d{1,2}\\.\\d{1,3})", 2)).matcher(serverinfo)).find()) {
                serverName = JavaEEServer.Jetty;
                serverVersion = Prerequisites.version3ToInt(mat_tomcat.group(1));
                found = true;
            }
            if (!found && (mat_tomcat = (pat_tomcat = Pattern.compile("JBoss.+(\\d{1,2}\\.\\d{1,2})", 2)).matcher(serverinfo)).find()) {
                serverName = JavaEEServer.JBoss;
                serverVersion = Prerequisites.version3ToInt(mat_tomcat.group(1) + ".0");
                found = true;
            }
            if (!found && (mat_tomcat = (pat_tomcat = Pattern.compile("WebLogic.+(\\d{1,2}\\.\\d{1,2})\\s+\\w*(\\d{1,2})", 2)).matcher(serverinfo)).find()) {
                serverName = JavaEEServer.WebLogic;
                serverVersion = Prerequisites.version3ToInt(mat_tomcat.group(1) + "." + mat_tomcat.group(2));
                found = true;
            }
            if (!found && (mat_tomcat = (pat_tomcat = Pattern.compile("WebSphere.+V(\\d{1,2}\\.\\d{1,2}\\.\\d{1,3})", 2)).matcher(serverinfo)).find()) {
                serverName = JavaEEServer.Websphere;
                serverVersion = Prerequisites.version3ToInt(mat_tomcat.group(1));
                found = true;
            }
            if (!found && (mat_tomcat = (pat_tomcat = Pattern.compile("Resin\\s+(\\d{1,2}\\.\\d{1,2}\\.\\d{1,3})", 2)).matcher(serverinfo)).find()) {
                serverName = JavaEEServer.Resin;
                serverVersion = Prerequisites.version3ToInt(mat_tomcat.group(1));
                found = true;
            }
            if (!found && (mat_glassfish = (pat_glassfish = Pattern.compile("GlassFish\\s+v(\\d{1,2})", 2)).matcher(serverinfo)).find()) {
                serverName = JavaEEServer.GlassFish;
                serverVersion = Prerequisites.version3ToInt(mat_glassfish.group(1));
                found = true;
            }
            if (!found && (mat_glassfish = (pat_glassfish = Pattern.compile("GlassFish.+(\\d{1,2}\\.\\d{1,2})", 2)).matcher(serverinfo)).find()) {
                serverName = JavaEEServer.GlassFish;
                serverVersion = Prerequisites.version3ToInt(mat_glassfish.group(1));
                found = true;
            }
            if (type == Type.ERROR) {
                if (this.errorJavaServletContainerList.contains((Object)serverName)) {
                    result = 32;
                } else if (!this.positiveJavaServletContainerList.containsKey((Object)serverName)) {
                    result = 32;
                } else {
                    ServerVersion sv = this.positiveJavaServletContainerList.get((Object)serverName);
                    boolean pass = true;
                    if (sv.minVersion != -1 && serverVersion < sv.minVersion) {
                        pass = false;
                    }
                    if (sv.maxVersion != -1 && serverVersion > sv.maxVersion) {
                        pass = false;
                    }
                    if (!pass) {
                        result = 32;
                    }
                }
            }
            if (this.verbose && result != 0) {
                if (type == Type.WARN) {
                    this.logger.log(1536, serverinfo);
                } else if (type == Type.ERROR) {
                    this.logger.log(1506, serverinfo);
                }
            }
        }
        return result;
    }

    private static int version3ToInt(String versionStr) {
        if (versionStr != null) {
            Pattern pat3 = Pattern.compile("(\\d+)\\.(\\d+)\\.(\\d+)");
            Matcher mat3 = pat3.matcher(versionStr);
            if (mat3.find()) {
                int d1 = Integer.valueOf(mat3.group(1));
                int d2 = Integer.valueOf(mat3.group(2));
                int d3 = Integer.valueOf(mat3.group(3));
                return d1 * 1000000 + d2 * 1000 + d3;
            }
            Pattern pat2 = Pattern.compile("(\\d+)\\.(\\d+)");
            Matcher mat2 = pat2.matcher(versionStr);
            if (mat2.find()) {
                int d1 = Integer.valueOf(mat2.group(1));
                int d2 = Integer.valueOf(mat2.group(2));
                return d1 * 1000000 + d2 * 1000;
            }
            try {
                return Integer.valueOf(versionStr) * 1000000;
            }
            catch (NumberFormatException e) {
                return -1;
            }
        }
        return -1;
    }

    private static long versionVMToInt(String versionStr) {
        Pattern pat;
        Matcher mat;
        long ret = -1L;
        if (versionStr != null && (mat = (pat = Pattern.compile("(\\d+)\\.(\\d+)\\.(\\d+)_(\\d+)")).matcher(versionStr)).find()) {
            int d1 = Integer.valueOf(mat.group(1));
            int d2 = Integer.valueOf(mat.group(2));
            int d3 = Integer.valueOf(mat.group(3));
            int d4 = Integer.valueOf(mat.group(4));
            ret = (long)d1 * 100000010L + (long)d2 * 100000L + (long)d3 * 1000L + (long)d4;
        }
        return ret;
    }

    class RequiredProperty {
        String propertyName = null;
        Type type = Type.WARN;
        String value = null;
        int logCode = -1;

        RequiredProperty() {
        }
    }

    class VMVersion {
        long minVersion = -1L;
        String minVersionStr;
        long maxVersion = -1L;
        String maxVersionStr;

        VMVersion() {
        }
    }

    class ServerVersion {
        int minVersion = -1;
        int maxVersion = -1;

        ServerVersion() {
        }
    }

    public static enum Type {
        ERROR,
        WARN;

    }
}

