/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiservletframework.security;

import com.neptunelabs.fsiframework.logging.FSILogger;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Calendar;
import java.util.Random;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.X509Extensions;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.x509.X509V3CertificateGenerator;

public abstract class KeyStoreGenerator {
    public static boolean generateKeyStore(FSILogger logger, Path keystoreFile, String keyalias, String certificatealias, String kspassword) {
        boolean success = false;
        if (Files.notExists(keystoreFile, new LinkOption[0])) {
            try {
                KeyPairGenerator kpg = KeyPairGenerator.getInstance("RSA");
                kpg.initialize(1024);
                KeyPair keyPair = kpg.generateKeyPair();
                Calendar notBefore = Calendar.getInstance();
                notBefore.add(5, -1);
                Calendar notAfter = Calendar.getInstance();
                notAfter.add(1, 10);
                Security.addProvider((Provider)new BouncyCastleProvider());
                X509V3CertificateGenerator generator = new X509V3CertificateGenerator();
                generator.setIssuerDN(new X500Principal("C=DE,O=Certificate Authority,CN=NeptuneLabs SA CA"));
                generator.setSubjectDN(new X500Principal("C=DE,CN=NeptuneLabs SA Certificate"));
                generator.setPublicKey(keyPair.getPublic());
                Random rh = new Random();
                generator.setSerialNumber(BigInteger.probablePrime(256, rh));
                generator.setNotBefore(notBefore.getTime());
                generator.setNotAfter(notAfter.getTime());
                generator.setSignatureAlgorithm("SHA256WithRSA");
                BasicConstraints bc = new BasicConstraints(true);
                generator.addExtension(X509Extensions.BasicConstraints.getId(), true, (ASN1Encodable)bc);
                X509Certificate cert = generator.generate(keyPair.getPrivate());
                Certificate[] chain = new Certificate[]{cert};
                KeyStore ks = KeyStore.getInstance("JKS");
                ks.load(null, kspassword.toCharArray());
                ks.setKeyEntry(keyalias, keyPair.getPrivate(), kspassword.toCharArray(), chain);
                Path keysDir = keystoreFile.getParent();
                if (Files.notExists(keysDir, new LinkOption[0])) {
                    Files.createDirectories(keysDir, new FileAttribute[0]);
                }
                OutputStream fos = Files.newOutputStream(keystoreFile, new OpenOption[0]);
                ks.store(fos, kspassword.toCharArray());
                fos.close();
                success = true;
            }
            catch (NoSuchAlgorithmException e) {
                logger.log(1595, e.getClass().getName() + ": " + e.getLocalizedMessage());
            }
            catch (SignatureException e) {
                logger.log(1595, e.getClass().getName() + ": " + e.getLocalizedMessage());
            }
            catch (InvalidKeyException e) {
                logger.log(1595, e.getClass().getName() + ": " + e.getLocalizedMessage());
            }
            catch (KeyStoreException e) {
                logger.log(1595, e.getClass().getName() + ": " + e.getLocalizedMessage());
            }
            catch (CertificateException e) {
                logger.log(1595, e.getClass().getName() + ": " + e.getLocalizedMessage());
            }
            catch (IOException e) {
                logger.log(1595, e.getClass().getName() + ": " + e.getLocalizedMessage());
            }
            catch (IllegalStateException e) {
                logger.log(1595, e.getClass().getName() + ": " + e.getLocalizedMessage());
            }
        }
        return success;
    }
}

