/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiservletframework.security;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.KeyStore;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.ws.security.components.crypto.CredentialException;
import org.apache.ws.security.components.crypto.Merlin;

public class ServletMerlin
extends Merlin {
    private static Path keystoreLocation;
    private static Path webinfpath;
    private static KeyStore myKeystore;

    public ServletMerlin(Properties properties) throws CredentialException, IOException {
        this(properties, ServletMerlin.class.getClassLoader());
    }

    public ServletMerlin(Properties properties, ClassLoader loader) throws CredentialException, IOException {
        super(null, loader);
        if (myKeystore == null) {
            if (keystoreLocation == null) {
                if (webinfpath == null) {
                    int pos;
                    URL resourceLocation = null;
                    Enumeration<URL> resourceLocations = loader.getResources("");
                    while (resourceLocations.hasMoreElements()) {
                        URL temp = resourceLocations.nextElement();
                        if (!temp.getPath().contains("WEB-INF")) continue;
                        resourceLocation = temp;
                        break;
                    }
                    if (resourceLocation != null && (pos = resourceLocation.getPath().indexOf("WEB-INF")) > 0) {
                        webinfpath = Paths.get(resourceLocation.getPath().substring(0, pos + 7), new String[0]);
                    }
                }
                if (webinfpath != null) {
                    String relativeLocation = properties.getProperty("org.apache.ws.security.crypto.merlin.file");
                    keystoreLocation = webinfpath.resolve(relativeLocation);
                }
            }
            if (keystoreLocation != null && Files.exists(keystoreLocation, new LinkOption[0])) {
                try (InputStream is = Files.newInputStream(keystoreLocation, new OpenOption[0]);){
                    String provider = properties.getProperty("org.apache.ws.security.crypto.merlin.keystore.provider");
                    String passwd = properties.getProperty("org.apache.ws.security.crypto.merlin.keystore.password", "security");
                    String type = properties.getProperty("org.apache.ws.security.crypto.merlin.keystore.type", KeyStore.getDefaultType());
                    myKeystore = this.load(is, passwd, provider, type);
                }
            }
        }
        this.keystore = myKeystore;
        this.properties = properties;
        this.loadCACerts = true;
    }

    public static void setKeystoreLocation(Path pathToKeystoreFile) {
        keystoreLocation = pathToKeystoreFile;
        myKeystore = null;
    }

    public static void setWebInfPath(Path path) {
        webinfpath = path;
        myKeystore = null;
    }

    public static void invalidateKeyStore() {
        myKeystore = null;
    }
}

