/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiservletframework.servletfilters;

import com.neptunelabs.fsiframework.logging.FSILogger;
import com.neptunelabs.fsiservletframework.servletfilters.GZipResponseWrapper;
import java.io.IOException;
import java.util.Enumeration;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class GZipFilter
implements Filter {
    private boolean enabled = true;
    private Thread.UncaughtExceptionHandler uncaughtExceptionHandler;
    private long filteredResponses = 0L;
    private long compressedResponses = 0L;

    public void init(FilterConfig filterconfig) throws ServletException {
        filterconfig.getServletContext().setAttribute("com.neptunelabs.fsiservletframework.servletfilters.GZipFilter", (Object)this);
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setLogger(FSILogger logger) {
    }

    public void setUncaughtExceptionHandler(Thread.UncaughtExceptionHandler uhe) {
        this.uncaughtExceptionHandler = uhe;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        block6: {
            try {
                if (this.enabled && request instanceof HttpServletRequest) {
                    ++this.filteredResponses;
                    HttpServletRequest httprequest = (HttpServletRequest)request;
                    HttpServletResponse httpresponse = (HttpServletResponse)response;
                    GZipResponseWrapper.CompressionType compression = this.getCompressionEncoding(httprequest);
                    if (compression != GZipResponseWrapper.CompressionType.NONE) {
                        ++this.compressedResponses;
                        httpresponse.setHeader("Vary", "Accept-Encoding");
                        GZipResponseWrapper wrappedResponse = new GZipResponseWrapper(httpresponse, null, compression, 300000, true);
                        chain.doFilter(request, (ServletResponse)wrappedResponse);
                        wrappedResponse.finishResponse();
                    } else {
                        chain.doFilter(request, response);
                    }
                } else {
                    chain.doFilter(request, response);
                }
            }
            catch (Exception e) {
                if (this.uncaughtExceptionHandler == null) break block6;
                this.uncaughtExceptionHandler.uncaughtException(null, e);
            }
        }
    }

    public void destroy() {
    }

    private GZipResponseWrapper.CompressionType getCompressionEncoding(HttpServletRequest request) {
        GZipResponseWrapper.CompressionType result = GZipResponseWrapper.CompressionType.NONE;
        Enumeration acceptEncodingEnum = request.getHeaders("Accept-Encoding");
        while (acceptEncodingEnum.hasMoreElements()) {
            String[] encodings;
            String rawEncoding = (String)acceptEncodingEnum.nextElement();
            for (String encoding : encodings = rawEncoding.split(",")) {
                if (encoding.equalsIgnoreCase("gzip")) {
                    result = GZipResponseWrapper.CompressionType.GZIP;
                    break;
                }
                if (!encoding.equalsIgnoreCase("deflate")) continue;
                result = GZipResponseWrapper.CompressionType.DEFLATE;
                break;
            }
            if (result == GZipResponseWrapper.CompressionType.NONE) continue;
            break;
        }
        return result;
    }

    public long getFilteredResponses() {
        return this.filteredResponses;
    }

    public long getCompressedResponses() {
        return this.compressedResponses;
    }
}

