/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiservletframework.servletfilters;

import com.neptunelabs.fsiframework.io.ByteArrayOutputStreamFast;
import com.neptunelabs.fsiservletframework.servletfilters.GZipResponseWrapper;
import java.io.IOException;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPOutputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.WriteListener;
import javax.servlet.http.HttpServletResponse;

public class GZipResponseStream
extends ServletOutputStream {
    private ByteArrayOutputStreamFast bufferedOutput = null;
    protected boolean closed = false;
    protected HttpServletResponse response = null;
    protected ServletOutputStream output = null;
    private final int bufferSize;
    private final GZipResponseWrapper.CompressionType compression;
    private boolean deliverPlain = false;

    public GZipResponseStream(HttpServletResponse response, GZipResponseWrapper.CompressionType compression, int maxSize) throws IOException {
        this.response = response;
        this.output = response.getOutputStream();
        this.compression = compression;
        this.bufferSize = maxSize;
        this.bufferedOutput = new ByteArrayOutputStreamFast();
    }

    public void close() throws IOException {
        if (this.closed) {
            throw new IOException("output stream is closed");
        }
        if (!this.deliverPlain) {
            ByteArrayOutputStreamFast baos = this.bufferedOutput;
            byte[] bytes = baos.toByteArray();
            ByteArrayOutputStreamFast compressedContent = new ByteArrayOutputStreamFast(bytes.length);
            DeflaterOutputStream cStream = this.compression == GZipResponseWrapper.CompressionType.DEFLATE ? new DeflaterOutputStream(compressedContent) : new GZIPOutputStream(compressedContent);
            cStream.write(bytes);
            cStream.finish();
            cStream.close();
            byte[] compressedBytes = compressedContent.toByteArray();
            this.response.setContentLength(compressedBytes.length);
            if (this.compression == GZipResponseWrapper.CompressionType.DEFLATE) {
                this.response.addHeader("Content-Encoding", "deflate");
            } else {
                this.response.addHeader("Content-Encoding", "gzip");
            }
            this.output.write(compressedBytes);
            this.output.flush();
            this.output.close();
            this.closed = true;
        } else {
            this.output.flush();
            this.output.close();
            this.closed = true;
        }
    }

    public void flush() throws IOException {
        if (this.closed) {
            throw new IOException("output stream is closed");
        }
        if (this.deliverPlain) {
            this.output.flush();
        } else {
            this.bufferedOutput.flush();
        }
    }

    public void write(int b) throws IOException {
        if (this.closed) {
            throw new IOException("output stream is closed");
        }
        this.checkBufferSize(1);
        if (this.deliverPlain) {
            this.output.write(b);
        } else {
            this.bufferedOutput.write((byte)b);
        }
    }

    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        if (this.closed) {
            throw new IOException("output stream is closed");
        }
        this.checkBufferSize(len);
        if (this.deliverPlain) {
            this.output.write(b, off, len);
        } else {
            this.bufferedOutput.write(b, off, len);
        }
    }

    private void checkBufferSize(int length) throws IOException {
        ByteArrayOutputStreamFast baos = this.bufferedOutput;
        if (baos.size() + length > this.bufferSize) {
            this.deliverPlain = true;
            this.bufferedOutput.close();
            this.output.write(this.bufferedOutput.toByteArray());
        }
    }

    public boolean isReady() {
        return true;
    }

    public void setWriteListener(WriteListener arg0) {
    }
}

