/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiservletframework.servletfilters;

import com.neptunelabs.fsiservletframework.servletfilters.GZipResponseStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.file.Path;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

public class GZipResponseWrapper
extends HttpServletResponseWrapper {
    protected HttpServletResponse origResponse = null;
    protected ServletOutputStream stream = null;
    protected PrintWriter writer = null;
    protected final CompressionType compression;
    protected final int maxSize;
    protected final Path reqFile;
    protected final boolean caching;

    public GZipResponseWrapper(HttpServletResponse response, Path reqFile, CompressionType compression, int maxSize, boolean caching) {
        super(response);
        this.origResponse = response;
        this.compression = compression;
        this.reqFile = reqFile;
        this.maxSize = maxSize;
        this.caching = caching;
    }

    public ServletOutputStream createOutputStream() throws IOException {
        return new GZipResponseStream(this.origResponse, this.compression, this.maxSize);
    }

    public void finishResponse() {
        try {
            if (this.writer != null) {
                this.writer.close();
            } else if (this.stream != null) {
                this.stream.close();
            }
        }
        catch (IOException iOException) {
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void flushBuffer() throws IOException {
        this.stream.flush();
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (this.writer != null) {
            throw new IllegalStateException("getWriter() has already been called!");
        }
        if (this.stream == null) {
            this.stream = this.createOutputStream();
        }
        return this.stream;
    }

    public PrintWriter getWriter() throws IOException {
        if (this.writer == null) {
            if (this.stream != null) {
                throw new IllegalStateException("getOutputStream() has already been called!");
            }
            this.stream = this.createOutputStream();
            this.writer = new PrintWriter(new OutputStreamWriter((OutputStream)this.stream, this.origResponse.getCharacterEncoding()));
        }
        return this.writer;
    }

    public static enum CompressionType {
        GZIP,
        DEFLATE,
        NONE;

    }
}

