/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiservletframework.servletfilters;

import java.io.IOException;
import java.util.Arrays;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

public class RequestCounterFilter
implements Filter {
    long totalRequests;
    long previousListOffset;
    long currentListOffset;
    int[] previousList = new int[60];
    int[] currentList = new int[60];

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        int pos;
        ++this.totalRequests;
        long currentSec = System.currentTimeMillis() / 1000L;
        long listOffset = currentSec / 60L;
        RequestCounterFilter requestCounterFilter = this;
        synchronized (requestCounterFilter) {
            if (listOffset > this.currentListOffset) {
                this.previousListOffset = this.currentListOffset;
                this.previousList = this.currentList;
                this.currentListOffset = listOffset;
                this.currentList = new int[60];
                Arrays.fill(this.currentList, 0);
            }
        }
        int n = pos = (int)(currentSec % 60L);
        this.currentList[n] = this.currentList[n] + 1;
        chain.doFilter(request, response);
    }

    public void destroy() {
    }

    public void init(FilterConfig config) throws ServletException {
        this.currentListOffset = System.currentTimeMillis() / 1000L / 60L;
        Arrays.fill(this.currentList, 0);
        Arrays.fill(this.previousList, 0);
        config.getServletContext().setAttribute("com.neptunelabs.fsiservletframework.servletfilters.RequestCounterFilter", (Object)this);
    }

    public float[] getRPSTriple() {
        float[] result = new float[3];
        long currentSec = System.currentTimeMillis() / 1000L;
        long listOffset = currentSec / 60L;
        if (listOffset > this.currentListOffset) {
            result[2] = 0.0f;
            result[1] = 0.0f;
            result[0] = 0.0f;
        } else {
            int pos = (int)(currentSec % 60L);
            result[0] = (float)this.summarize(pos, 5) / 5.0f;
            result[1] = (float)this.summarize(pos, 15) / 15.0f;
            result[2] = (float)this.summarize(pos, 60) / 60.0f;
        }
        return result;
    }

    private int summarize(int pos, int count) {
        int r = 0;
        for (int i = 0; i < count; ++i) {
            int arraypos = pos - i;
            if (arraypos >= 0) {
                r += this.currentList[arraypos];
                continue;
            }
            r += this.previousList[60 + arraypos];
        }
        return r;
    }
}

