/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiservletframework.settings;

import com.neptunelabs.fsiframework.collections.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class Section {
    private boolean enabled = false;
    private final SectionTypes type;
    private final HashMap<String, String> attributes = new HashMap(0);
    private final HashMap<String, String> valueNames = new HashMap(0);
    private final HashMap<String, ArrayList<String>> valueList = new HashMap(0);
    private final Map<String, List<List<Pair<String, String>>>> attrList = new HashMap<String, List<List<Pair<String, String>>>>(0);

    public Section(SectionTypes sectype) {
        this.type = sectype;
    }

    public void remove(String key, String value) {
        if ((key = key.toLowerCase()) != null) {
            switch (this.type) {
                case valueNames: {
                    if (value != null && !this.valueNames.get(key).equals(value)) break;
                    this.valueNames.remove(key);
                    break;
                }
                case valueList: {
                    if (!this.valueList.containsKey(key)) break;
                    if (value == null) {
                        this.valueList.remove(key);
                        break;
                    }
                    ArrayList<String> list = this.valueList.get(key);
                    list.remove(value);
                    break;
                }
            }
        }
    }

    public void put(String key, String value) {
        if (key != null && value != null) {
            key = key.toLowerCase();
            switch (this.type) {
                case valueNames: {
                    this.valueNames.put(key, value);
                    break;
                }
                case valueList: {
                    ArrayList<Object> list;
                    if (this.valueList.containsKey(key)) {
                        list = this.valueList.get(key);
                    } else {
                        list = new ArrayList();
                        this.valueList.put(key, list);
                    }
                    if (list.contains(value)) break;
                    list.add(value);
                    break;
                }
            }
        }
    }

    public void putAttribute(String key, List<Pair<String, String>> attrKeys) {
        if (key != null) {
            key = key.toLowerCase();
            switch (this.type) {
                case valueNames: 
                case valueList: {
                    break;
                }
                case attrList: {
                    List<Object> list;
                    if (this.attrList.containsKey(key)) {
                        list = this.attrList.get(key);
                    } else {
                        list = new ArrayList();
                        this.attrList.put(key, list);
                    }
                    list.add(attrKeys);
                    break;
                }
            }
        }
    }

    String getValue(String key) {
        String ret = null;
        if (key != null && this.type == SectionTypes.valueNames) {
            key = key.toLowerCase();
            ret = this.valueNames.get(key);
        }
        return ret;
    }

    ArrayList<String> getValueList(String key) {
        ArrayList<String> ret = null;
        if (key != null && this.type == SectionTypes.valueList) {
            key = key.toLowerCase();
            ret = this.valueList.get(key);
        }
        return ret;
    }

    List<List<Pair<String, String>>> getAttrList(String key) {
        List<List<Pair<String, String>>> ret = null;
        if (key != null && this.type == SectionTypes.attrList) {
            key = key.toLowerCase();
            ret = this.attrList.get(key);
        }
        return ret;
    }

    Set<String> getKeys() {
        Set<String> keys = null;
        switch (this.type) {
            case valueNames: {
                keys = this.valueNames.keySet();
                break;
            }
            case valueList: {
                keys = this.valueList.keySet();
                break;
            }
            case attrList: {
                keys = this.attrList.keySet();
                break;
            }
        }
        return keys;
    }

    void putAttribute(String key, String value) {
        key = key.toLowerCase();
        this.attributes.put(key, value);
    }

    synchronized void deleteAttribute(String key, String value) {
        key = key.toLowerCase();
        this.attributes.remove(key);
    }

    String getAttribute(String key) {
        key = key.toLowerCase();
        return this.attributes.get(key);
    }

    public void enable(boolean state) {
        this.enabled = state;
    }

    boolean getEnabled() {
        return this.enabled;
    }

    public boolean hasValueName(String key) {
        return this.valueNames.containsKey(key);
    }

    public boolean hasValueList(String key) {
        return this.valueList.containsKey(key);
    }

    public boolean hasAttributeList(String key) {
        return this.attrList.containsKey(key);
    }

    SectionTypes getType() {
        return this.type;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("SectionType: " + (Object)((Object)this.type) + "\n");
        sb.append("Enabled: " + this.enabled + "\n");
        sb.append("Keys: " + this.getKeys() + "\n");
        return sb.toString();
    }

    public static enum SectionTypes {
        valueNames,
        valueList,
        attrList;

    }
}

