/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiservletframework.settings;

import com.neptunelabs.fsiframework.SoftwareVersion;
import com.neptunelabs.fsiframework.collections.Pair;
import com.neptunelabs.fsiframework.io.FileOperations;
import com.neptunelabs.fsiframework.licensing.Licence;
import com.neptunelabs.fsiframework.licensing.LicenceConsumer;
import com.neptunelabs.fsiframework.licensing.LicenceManager;
import com.neptunelabs.fsiframework.licensing.RawLicence;
import com.neptunelabs.fsiframework.logging.FSILogger;
import com.neptunelabs.fsiframework.systeminformation.SystemInformation;
import com.neptunelabs.fsiservletframework.ExtendedServlet;
import com.neptunelabs.fsiservletframework.settings.Section;
import com.neptunelabs.fsiservletframework.utils.ServletFileEventCursor;
import com.neptunelabs.fsiservletframework.utils.ServletUtils;
import java.io.File;
import java.io.IOException;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.file.Path;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.GenericServlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class ServletXMLSettings
implements LicenceConsumer {
    public static final int WEEKDAY_MONDAY = 1;
    public static final int WEEKDAY_TUESDAY = 2;
    public static final int WEEKDAY_WEDNESDAY = 4;
    public static final int WEEKDAY_THURSDAY = 8;
    public static final int WEEKDAY_FRIDAY = 16;
    public static final int WEEKDAY_SATURDAY = 32;
    public static final int WEEKDAY_SUNDAY = 64;
    private static final String temporaryUpdateDirectory = "/WEB-INF/tempUpdateFiles";
    private Path file;
    private boolean secureMode = false;
    protected SecurityManager security;
    protected FSILogger logger;
    protected final GenericServlet servlet;
    protected final ServletContext servletContext;
    protected final ServletConfig servletConfig;
    protected final SystemInformation systemInformation;
    private final long startTime;
    private boolean maintenanceModeEnabled = false;
    private final Map<String, Boolean> backupDirectories = new HashMap<String, Boolean>();
    private final Map<String, Boolean> viewableDirectories = new HashMap<String, Boolean>();
    private final DecimalFormat nullformat = new DecimalFormat("00");
    private Map<String, Section> defaultSections = new HashMap<String, Section>();
    private final Map<String, Section> settingsSections = new HashMap<String, Section>();
    private final List<Path> protectedDirs = new ArrayList<Path>();
    protected final ServletFileEventCursor fileEventCursor;
    private ServletFileEventCursor.RegisteredPathServlet fileEventServletTask;
    protected volatile boolean settingsFileEvaluated = false;
    protected volatile Licence licence = new Licence();
    protected LicenceManager licenceManager;
    protected Integer requiredAppId;
    protected Integer requiredMajorVersion;
    protected boolean hasValidLicence = false;
    protected boolean hasOtherMajor = false;
    protected boolean hardwareIDMatches = false;
    private Path helpDirectory = null;
    private final Pattern ipPattern = Pattern.compile("(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?).){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)");
    private final Map<String, Inet6Address> ipv6Cache = new HashMap<String, Inet6Address>(2);

    protected ServletXMLSettings(GenericServlet servlet, boolean autorestart, ServletFileEventCursor fileEventCursor, boolean export) {
        this.servlet = servlet;
        if (servlet != null) {
            this.servletConfig = servlet.getServletConfig();
            this.servletContext = servlet.getServletContext();
        } else {
            this.servletConfig = null;
            this.servletContext = null;
        }
        this.fileEventCursor = fileEventCursor;
        try {
            File tmp = File.createTempFile("sectest", "tmp");
            if (!tmp.delete()) {
                tmp.deleteOnExit();
            }
        }
        catch (SecurityException e) {
            this.secureMode = true;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.security = System.getSecurityManager();
        this.systemInformation = new SystemInformation();
        this.startTime = System.currentTimeMillis();
        if (this.servletContext != null) {
            if (export) {
                this.servletContext.setAttribute("FSIServletSettings", (Object)this);
            }
            this.protectedDirs.add(ServletUtils.getRealPath(this.servletContext, temporaryUpdateDirectory));
        }
    }

    protected void addProtectedDir(Path f) {
        this.protectedDirs.add(f);
    }

    public Path getRealDir(String internalPath) {
        return ServletUtils.getRealPath(this.servletContext, "WEB-INF").resolve(internalPath);
    }

    public synchronized boolean isProtectedDir(Path f) {
        boolean result = false;
        for (Path pdir : this.protectedDirs) {
            if (!f.toAbsolutePath().startsWith(pdir.toAbsolutePath())) continue;
            result = true;
            break;
        }
        return result;
    }

    public boolean isBackupDir(String path) {
        boolean result = false;
        if (this.backupDirectories.containsKey(path)) {
            result = true;
        } else {
            String currentpath = path;
            while (currentpath.length() > 1) {
                currentpath = currentpath.substring(0, currentpath.length() - 1);
                if (!this.backupDirectories.containsKey(currentpath = currentpath.substring(0, currentpath.lastIndexOf(File.separator) + 1)) || !this.backupDirectories.get(currentpath).booleanValue()) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    public boolean isRestarting() {
        return this.fileEventCursor != null ? this.fileEventCursor.isRestarting() : false;
    }

    protected void addBackupDir(String path) {
        this.backupDirectories.put(path, false);
    }

    protected void addBackupDir(String path, boolean recursive) {
        this.backupDirectories.put(path, recursive);
    }

    public boolean isViewableDir(String path) {
        boolean result = false;
        if (this.viewableDirectories.containsKey(path)) {
            result = true;
        } else {
            String currentpath = path;
            while (currentpath.length() > 1) {
                currentpath = currentpath.substring(0, currentpath.length() - 1);
                if (!this.viewableDirectories.containsKey(currentpath = currentpath.substring(0, currentpath.lastIndexOf(File.separator) + 1)) || !this.viewableDirectories.get(currentpath).booleanValue()) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    protected void addViewableDir(String path) {
        this.addViewableDir(path, false);
    }

    protected void addViewableDir(String path, boolean recursive) {
        this.viewableDirectories.put(path, recursive);
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public ServletConfig getServletConfig() {
        return this.servletConfig;
    }

    public SystemInformation getSystemInformation() {
        return this.systemInformation;
    }

    public Licence getLicence() {
        return this.licence;
    }

    public String getLicenceContainerHash() {
        return this.licenceManager.getLicenceContainerHash();
    }

    public long getUptime() {
        return this.startTime;
    }

    public void dispose() {
        if (this.licenceManager != null) {
            this.licenceManager.shutdown();
        }
    }

    public final void setSettingsFile(Path file) {
        this.file = file;
    }

    public final void setAdministratorHelpDiretory(Path file) {
        this.helpDirectory = file;
    }

    public final Path getAdministratorHelpDiretory() {
        return this.helpDirectory;
    }

    public final void addRestartableServlet(ExtendedServlet servletParam) {
        if (this.fileEventServletTask != null) {
            this.fileEventServletTask.addRestartableServlet(servletParam);
        }
    }

    public ServletFileEventCursor getServletFileEventCursor() {
        return this.fileEventCursor;
    }

    public final void setLicenceFile(Path filename, int appid, int majorVersion) throws IOException {
        this.requiredAppId = appid;
        this.requiredMajorVersion = majorVersion;
        this.licenceManager = new LicenceManager(this.logger, filename);
        this.licenceManager.setFileEventCursor(this.fileEventCursor);
        this.updateLicenceFromLicenceManager();
        this.licenceManager.addConsumer(this);
    }

    public final LicenceManager getLicenceManager() {
        return this.licenceManager;
    }

    @Override
    public void updateLicenceFromLicenceManager() {
        this.licence = new Licence();
        if (this.licenceManager != null) {
            RawLicence rl = this.licenceManager.getRawLicence(this.requiredAppId, this.requiredMajorVersion);
            if (rl != null && rl.licence != null) {
                this.hasValidLicence = this.licence.decodeLicenceString(this.logger, rl.licence, SoftwareVersion.getKeyVersion(), this.requiredAppId, this.requiredMajorVersion, SoftwareVersion.readPublicKey(), rl.lastModified);
                this.hardwareIDMatches = this.validateHardwareID(this.systemInformation.getMacs(), this.licence.getMacAddresses());
                if (!this.hardwareIDMatches) {
                    this.hasValidLicence = false;
                }
            } else {
                this.hasOtherMajor = this.licenceManager.hasRawLicences(this.requiredAppId);
                this.hasValidLicence = false;
            }
        }
        this.logLicenceInfo();
    }

    public boolean validateHardwareID(byte[][] myMACS, byte[][] otherMACS) {
        if (otherMACS != null && myMACS != null) {
            for (byte[] myMac : myMACS) {
                for (byte[] element : otherMACS) {
                    if (!Arrays.equals(myMac, element)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public void logLicenceInfo() {
        if (this.logger != null) {
            if (!this.hasValidLicence() && this.getLicenceErrorCode() > 0) {
                if (this.getLicenceErrorCode() == 4) {
                    this.logger.log(7006, new Object[0]);
                } else {
                    this.logger.log(7001, this.getLicenceErrorCode());
                }
            } else if (this.hasOtherMajor) {
                this.logger.log(7006, new Object[0]);
            } else if (!this.hasValidLicence() && this.getLicenceErrorCode() == 0) {
                this.logger.log(7002, this.getLicenceErrorCode());
            } else if (this.hasValidLicence()) {
                this.logger.log(7000, new Object[0]);
            }
        }
    }

    public final boolean hasValidLicence() {
        return this.hasValidLicence;
    }

    public final int getLicenceErrorCode() {
        return this.licence.getErrorCode();
    }

    public final boolean evalutateSettings() {
        boolean ret = true;
        Document doc = FileOperations.getXMLFileContent(this.logger, this.file);
        this.settingsSections.clear();
        if (doc != null) {
            Element rootnode = doc.getDocumentElement();
            NodeList nodelist = rootnode.getChildNodes();
            for (int i = 0; i < nodelist.getLength(); ++i) {
                Section sec;
                Node sectionNode = nodelist.item(i);
                if (sectionNode.getNodeType() != 1) continue;
                String sectionName = sectionNode.getNodeName().toLowerCase();
                boolean enabled = true;
                Section.SectionTypes sectionType = null;
                if (sectionNode.hasAttributes()) {
                    Node typeNode;
                    NamedNodeMap sectionAttributes = sectionNode.getAttributes();
                    Node enabledNode = sectionAttributes.getNamedItem("enabled");
                    if (enabledNode != null) {
                        String enabledStr = enabledNode.getNodeValue();
                        enabled = Boolean.valueOf(enabledStr);
                    }
                    if ((typeNode = sectionAttributes.getNamedItem("type")) != null) {
                        try {
                            sectionType = Section.SectionTypes.valueOf(typeNode.getNodeValue());
                        }
                        catch (IllegalArgumentException e) {
                            this.logger.log(1513, this.file, sectionName);
                        }
                    }
                }
                if (sectionType == null && this.defaultSections != null && (sec = this.defaultSections.get(sectionNode.getNodeName())) != null) {
                    sectionType = sec.getType();
                }
                if (sectionType == null) {
                    sectionType = Section.SectionTypes.valueNames;
                }
                Section section = new Section(sectionType);
                section.enable(enabled);
                if (sectionNode.hasChildNodes()) {
                    NodeList paramNodeList = sectionNode.getChildNodes();
                    block7: for (int p = 0; p < paramNodeList.getLength(); ++p) {
                        Node paramNode = paramNodeList.item(p);
                        if (paramNode.getNodeType() != 1) continue;
                        String parameterName = paramNode.getNodeName().toLowerCase();
                        if (sectionType == Section.SectionTypes.valueNames && !this.isValidValueName(sectionName, parameterName) && this.logger != null) {
                            this.logger.log(1574, parameterName, sectionName, this.file);
                            continue;
                        }
                        switch (sectionType) {
                            case valueNames: {
                                String val1 = this.cleanValue(this.getNodeTextContent(paramNode.getChildNodes()));
                                if (val1 == null) continue block7;
                                section.put(parameterName, val1);
                                continue block7;
                            }
                            case valueList: {
                                String val2 = this.cleanValue(this.getNodeTextContent(paramNode.getChildNodes()));
                                if (val2 == null) continue block7;
                                section.put(parameterName, val2);
                                continue block7;
                            }
                            default: {
                                NamedNodeMap paramAttrs = paramNode.getAttributes();
                                int attrLen = paramAttrs.getLength();
                                ArrayList<Pair<String, String>> list = new ArrayList<Pair<String, String>>();
                                for (int c = 0; c < attrLen; ++c) {
                                    Node attr = paramAttrs.item(c);
                                    String attrName = attr.getNodeName();
                                    String attrValue = this.cleanValue(attr.getNodeValue());
                                    if (attrValue == null) continue;
                                    Pair<String, String> pair = new Pair<String, String>(attrName, attrValue);
                                    list.add(pair);
                                }
                                section.putAttribute(parameterName, list);
                            }
                        }
                    }
                }
                this.settingsSections.put(sectionName, section);
            }
        }
        this.settingsFileEvaluated = true;
        return true;
    }

    public boolean hasSection(String sectionKey) {
        Section section = this.getSection(sectionKey);
        return section != null;
    }

    public boolean hasSectionEnabled(String sectionKey) {
        Section section = this.getSection(sectionKey);
        boolean ret = section != null ? section.getEnabled() : false;
        return ret;
    }

    public void enableSection(String sectionKey, String state) {
        this.enableSection(sectionKey, Boolean.valueOf(state));
    }

    public void enableSection(String sectionKey, boolean state) {
        Section section = this.getSection(sectionKey);
        if (section != null) {
            section.enable(state);
        } else {
            this.logger.log(1573, sectionKey);
        }
    }

    public String getPrefsString(String sectionName, String key) {
        String ret = null;
        if ((key = key.toLowerCase()).equals("datetime")) {
            GregorianCalendar cal = new GregorianCalendar();
            StringBuilder time = new StringBuilder();
            time.append(this.nullformat.format(cal.get(11)));
            time.append(':');
            time.append(this.nullformat.format(cal.get(12)));
            time.append(':');
            time.append(this.nullformat.format(cal.get(13)));
            ret = time.toString();
        } else if (key.equals("vendor")) {
            ret = "NeptuneLabs";
        } else if (this.isValidValueName(sectionName, key)) {
            String defaultValue = this.getDefaultValue(sectionName, key);
            ret = this.getPrefs(sectionName, key, defaultValue);
        }
        return ret;
    }

    public boolean getPrefsBoolean(String sectionName, String key) {
        String defaultValue;
        String obj;
        boolean ret = false;
        if (this.isValidValueName(sectionName, key = key.toLowerCase()) && (obj = this.getPrefs(sectionName, key, defaultValue = this.getDefaultValue(sectionName, key))) != null) {
            ret = Boolean.valueOf(obj);
        }
        return ret;
    }

    public int getPrefsInt(String sectionName, String key) {
        String defaultValue;
        String obj;
        int ret = 0;
        if (this.isValidValueName(sectionName, key = key.toLowerCase()) && (obj = this.getPrefs(sectionName, key, defaultValue = this.getDefaultValue(sectionName, key))) != null && !obj.equals("")) {
            try {
                ret = Integer.valueOf(obj);
            }
            catch (NumberFormatException e) {
                this.logger.log(1572, sectionName, key);
            }
        }
        return ret;
    }

    public long getPrefsLong(String sectionName, String key) {
        String defaultValue;
        String obj;
        long ret = 0L;
        if (this.isValidValueName(sectionName, key = key.toLowerCase()) && (obj = this.getPrefs(sectionName, key, defaultValue = this.getDefaultValue(sectionName, key))) != null) {
            try {
                ret = Long.valueOf(obj);
            }
            catch (NumberFormatException e) {
                this.logger.log(1572, sectionName, key);
            }
        }
        return ret;
    }

    public List<String> getPrefsValues(String sectionName, String key) {
        key = key.toLowerCase();
        Section section = this.getSection(sectionName, Section.SectionTypes.valueList);
        return section.getValueList(key);
    }

    public List<List<Pair<String, String>>> getPrefsAttributeList(String key, String tag) {
        key = key.toLowerCase();
        Section section = this.getSection(key, Section.SectionTypes.attrList);
        return section.getAttrList(tag);
    }

    public int getTimeInDaySecs(String sectionName, String key) {
        int ret = -1;
        String value = this.getPrefsString(sectionName, key = key.toLowerCase());
        if (value != null) {
            Pattern timehhmmpat = Pattern.compile("^\\s*(\\d{1,2}):(\\d{2})\\s*$");
            Pattern timehhmmsspat = Pattern.compile("^\\s*(\\d{1,2}):(\\d{2}):(\\d{2})\\s*$");
            int hour = 0;
            int minute = 0;
            int second = 0;
            try {
                Matcher timehhmmmat = timehhmmpat.matcher(value);
                if (timehhmmmat.find()) {
                    String hourstr = timehhmmmat.group(1);
                    String minutestr = timehhmmmat.group(2);
                    hour = Integer.valueOf(hourstr);
                    minute = Integer.valueOf(minutestr);
                    ret = hour * 3600 + minute * 60;
                } else {
                    Matcher timehhmmssmat = timehhmmsspat.matcher(value);
                    if (timehhmmssmat.find()) {
                        String hourstr = timehhmmssmat.group(1);
                        String minutestr = timehhmmssmat.group(2);
                        String secondstr = timehhmmssmat.group(3);
                        hour = Integer.valueOf(hourstr);
                        minute = Integer.valueOf(minutestr);
                        second = Integer.valueOf(secondstr);
                        ret = hour * 3600 + minute * 60 + second;
                    }
                }
            }
            catch (NumberFormatException e) {
                ret = -1;
            }
        }
        return ret;
    }

    public int getPrefsWeekdaySet(String sectionName, String key) {
        int ret = 0;
        String value = this.getPrefsString(sectionName, key = key.toLowerCase());
        if (value != null) {
            StringTokenizer st = new StringTokenizer(value, ";,");
            while (st.hasMoreTokens()) {
                String day = st.nextToken().toLowerCase();
                if (day.equals("mon") || day.equals("monday")) {
                    ret |= 1;
                    continue;
                }
                if (day.equals("tue") || day.equals("tuesday")) {
                    ret |= 2;
                    continue;
                }
                if (day.equals("wed") || day.equals("wednesday")) {
                    ret |= 4;
                    continue;
                }
                if (day.equals("thu") || day.equals("thursday")) {
                    ret |= 8;
                    continue;
                }
                if (day.equals("fri") || day.equals("friday")) {
                    ret |= 0x10;
                    continue;
                }
                if (day.equals("sat") || day.equals("saturday")) {
                    ret |= 0x20;
                    continue;
                }
                if (!day.equals("sun") && !day.equals("sunday")) continue;
                ret |= 0x40;
            }
        }
        return ret;
    }

    protected long getHumanRAMBytes(String ramString) {
        long preValue = -1L;
        Pattern pat = Pattern.compile("(\\d+)\\s*([etgmkbip]*)", 2);
        Matcher mat = pat.matcher(ramString);
        if (mat.find()) {
            String number = mat.group(1);
            String unit = mat.group(2);
            preValue = Long.parseLong(number);
            if (unit != null) {
                if ((unit = unit.toLowerCase()).equals("k") || unit.equals("kb")) {
                    preValue *= 1000L;
                } else if (unit.equals("kib")) {
                    preValue *= 1024L;
                } else if (unit.equals("m") || unit.equals("mb")) {
                    preValue *= 1000000L;
                } else if (unit.equals("mib")) {
                    preValue *= 0x100000L;
                } else if (unit.equals("g") || unit.equals("gb")) {
                    preValue *= 1000000000L;
                } else if (unit.equals("gib")) {
                    preValue *= 0x40000000L;
                } else if (unit.equals("t") || unit.equals("tb")) {
                    preValue *= 1000000000000L;
                } else if (unit.equals("tib")) {
                    preValue *= 0x10000000000L;
                } else if (unit.equals("p") || unit.equals("pb")) {
                    preValue *= 1000000000000000L;
                } else if (unit.equals("pib")) {
                    preValue *= 0x4000000000000L;
                } else if (unit.equals("e") || unit.equals("eb")) {
                    preValue *= 1000000000000000000L;
                } else if (unit.equals("eib")) {
                    preValue *= 0x1000000000000000L;
                }
            }
        }
        return preValue;
    }

    public void setAttribute(String sectionName, Section.SectionTypes sectionType, String key, String value) {
        Section section = this.getSection(sectionName, sectionType);
        section.putAttribute(key, value);
    }

    public void setPrefs(String sectionName, Section.SectionTypes sectionType, String key, String value) {
        this.setPrefs(sectionName, sectionType, key, value, false);
    }

    public void setPrefs(String sectionName, Section.SectionTypes sectionType, String key, String value, boolean doAddNewSection) {
        if (!doAddNewSection && !this.isValidValueName(sectionName, key)) {
            return;
        }
        Section section = this.getSection(sectionName, sectionType);
        section.put(key, value);
    }

    public void removePrefs(String sectionName, Section.SectionTypes sectionType, String key, String value) {
        Section section = this.getSection(sectionName, sectionType);
        if (section != null) {
            section.remove(key, value);
        }
    }

    public void setDefaultSection(Map<String, Section> df) {
        this.defaultSections = df;
    }

    public boolean saveSettingsFile() {
        boolean ret = false;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            DOMImplementation domimpl = builder.getDOMImplementation();
            Document doc = domimpl.createDocument(null, "settings", null);
            Element rootNode = doc.getDocumentElement();
            for (String sectionname : this.defaultSections.keySet()) {
                Section section = this.getSection(sectionname);
                Element sectionNode = doc.createElement(sectionname);
                sectionNode.setAttribute("enabled", Boolean.toString(section.getEnabled()));
                Section.SectionTypes sectionType = section.getType();
                block7: for (String key : section.getKeys()) {
                    switch (sectionType) {
                        case valueNames: {
                            String defaultValue = this.getDefaultValue(sectionname, key);
                            String value = section.getValue(key);
                            if (value.equalsIgnoreCase(defaultValue)) continue block7;
                            Element valueNode = doc.createElement(key);
                            valueNode.setTextContent(value);
                            sectionNode.appendChild(valueNode);
                            break;
                        }
                        case valueList: {
                            sectionNode.setAttribute("type", "valueList");
                            ArrayList<String> listvalues = section.getValueList(key);
                            for (String listvalue : listvalues) {
                                Element valueNode = doc.createElement(key);
                                valueNode.setTextContent(listvalue);
                                sectionNode.appendChild(valueNode);
                            }
                            continue block7;
                        }
                        default: {
                            sectionNode.setAttribute("type", "attrList");
                            List<List<Pair<String, String>>> attrList = section.getAttrList(key);
                            Element valueNode = doc.createElement(key);
                            for (List<Pair<String, String>> attrs : attrList) {
                                for (Pair<String, String> attrKey : attrs) {
                                    String attrName = attrKey.getItem1();
                                    String attrValue = attrKey.getItem2();
                                    if (attrValue == null) continue;
                                    valueNode.setAttribute(attrName, attrValue);
                                }
                            }
                            sectionNode.appendChild(valueNode);
                        }
                    }
                }
                rootNode.appendChild(sectionNode);
            }
            ret = FileOperations.saveXMLFileContent(this.logger, this.file, doc);
        }
        catch (ParserConfigurationException e) {
            this.logger.log(1517, this.file, e);
        }
        return ret;
    }

    public Path getSettingsFile() {
        return this.file;
    }

    public final void setFSILogger(FSILogger logger) {
        this.logger = logger;
    }

    public final FSILogger getFSILogger() {
        return this.logger;
    }

    public final boolean getSecured() {
        return this.secureMode;
    }

    public void log(String msg) {
        if (this.servlet != null) {
            this.servlet.log(msg);
        }
    }

    private Section getSection(String sectionName) {
        return this.getSection(sectionName, Section.SectionTypes.valueNames);
    }

    private Section getSection(String sectionName, Section.SectionTypes sectionType) {
        Section section;
        if (this.settingsSections.containsKey(sectionName = sectionName.toLowerCase())) {
            section = this.settingsSections.get(sectionName);
        } else {
            section = new Section(sectionType);
            this.settingsSections.put(sectionName, section);
        }
        return section;
    }

    private String getPrefs(String sectionName, String key, String ret) {
        String value;
        Section section = this.getSection(sectionName);
        if (section.getType() == Section.SectionTypes.valueNames && (value = section.getValue(key)) != null) {
            ret = value;
        }
        return ret;
    }

    private String cleanValue(String value) {
        String ret = null;
        if (value != null && !(value = value.trim()).equals("")) {
            ret = value;
        }
        return ret;
    }

    private boolean isValidValueName(String sectionName, String key) {
        boolean returnvalue = false;
        key = key.toLowerCase();
        Section section = this.defaultSections.get(sectionName);
        if (section != null) {
            if (section.getType() == Section.SectionTypes.valueNames && section.hasValueName(key)) {
                returnvalue = true;
            } else if (section.getType() == Section.SectionTypes.valueList && section.hasValueList(key)) {
                returnvalue = true;
            } else if (section.getType() == Section.SectionTypes.attrList && section.hasAttributeList(key)) {
                returnvalue = true;
            }
        }
        if (!returnvalue && this.logger != null) {
            this.logger.log(1572, sectionName, key);
        }
        return returnvalue;
    }

    private String getDefaultValue(String sectionName, String key) {
        String ret = null;
        Section section = this.defaultSections.get(sectionName);
        if (section != null) {
            ret = section.getValue(key);
        }
        return ret;
    }

    public boolean isMaintenanceModeEnabled() {
        return this.maintenanceModeEnabled;
    }

    public void setMaintenanceModeEnabled(boolean maintenanceModeEnabled) {
        this.maintenanceModeEnabled = maintenanceModeEnabled;
    }

    public Path getWebInfPath() {
        if (this.servletContext != null) {
            return ServletUtils.getRealPath(this.servletContext, "WEB-INF");
        }
        return null;
    }

    public Path getTemporaryUpdateDirectory() {
        return ServletUtils.getRealPath(this.servletContext, temporaryUpdateDirectory);
    }

    public String getNodeTextContent(NodeList nl) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (n.getNodeType() != 3) continue;
            sb.append(n.getNodeValue());
        }
        return sb.toString().trim();
    }

    public boolean isLocalRange(String localHost) {
        boolean result = false;
        if (localHost.equalsIgnoreCase("localhost")) {
            result = true;
        } else if (localHost.length() <= 15) {
            result = this.isLocalIPv4Address(localHost);
        }
        if (!result && localHost.startsWith("[") && localHost.endsWith("]")) {
            result = this.isLocalIPv6Address(localHost);
        }
        return result;
    }

    private boolean isLocalIPv6Address(String localHost) {
        String addressStr = localHost.substring(1, localHost.length() - 1);
        try {
            InetAddress address = InetAddress.getByName(addressStr);
            if (address instanceof Inet6Address) {
                byte[] bytes = address.getAddress();
                if ((bytes[0] & 0xFF) == 254 && (bytes[1] & 0xC0) == 128) {
                    return true;
                }
                if ((bytes[0] & 0xFF) == 252 || (bytes[0] & 0xFF) == 253) {
                    return true;
                }
                byte test = 0;
                for (int i = 0; i < 15; ++i) {
                    test = (byte)(test | bytes[i]);
                }
                return test == 0 && bytes[15] == 1;
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return false;
    }

    private boolean isLocalIPv4Address(String localHost) {
        boolean result = false;
        Matcher mat = this.ipPattern.matcher(localHost);
        if (mat.matches()) {
            long ip = this.ipv4ToLong(localHost);
            if (ip == 0L) {
                result = true;
            } else if (ip >= 0xA000000L && ip <= 0xAFFFFFFL) {
                result = true;
            } else if (ip >= 2886729728L && ip <= 2887778303L) {
                result = true;
            } else if (ip >= 3232235520L && ip <= 3232301055L) {
                result = true;
            } else if (ip >= 2851995648L && ip <= 2852061183L) {
                result = true;
            } else if (ip >= 0x7F000000L && ip <= Integer.MAX_VALUE) {
                result = true;
            }
        }
        return result;
    }

    private long ipv4ToLong(String addr) {
        String[] addrArray = addr.split("\\.", 4);
        long num = 0L;
        for (int i = 0; i < addrArray.length; ++i) {
            int power = 3 - i;
            num = (long)((double)num + (double)(Integer.parseInt(addrArray[i]) % 256) * Math.pow(256.0, power));
        }
        return num;
    }

    protected Inet6Address getInet6Address(String licenceHost, boolean allowCaching) {
        if (!this.ipv6Cache.containsKey(licenceHost)) {
            try {
                InetAddress address = InetAddress.getByName(licenceHost);
                if (address instanceof Inet6Address) {
                    if (allowCaching) {
                        this.ipv6Cache.put(licenceHost, (Inet6Address)address);
                    }
                    return (Inet6Address)address;
                }
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        return this.ipv6Cache.get(licenceHost);
    }
}

