/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiservletframework.strtotime;

import com.neptunelabs.fsiservletframework.strtotime.DateFormatMatcher;
import com.neptunelabs.fsiservletframework.strtotime.DaysMatcher;
import com.neptunelabs.fsiservletframework.strtotime.Matcher;
import com.neptunelabs.fsiservletframework.strtotime.MinutesMatcher;
import com.neptunelabs.fsiservletframework.strtotime.NowMatcher;
import com.neptunelabs.fsiservletframework.strtotime.TomorrowMatcher;
import com.neptunelabs.fsiservletframework.strtotime.WeeksMatcher;
import com.neptunelabs.fsiservletframework.strtotime.YesterdayMatcher;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;

public final class Str2Time {
    private static final List<Matcher> matchers = new LinkedList<Matcher>();

    public static void registerMatcher(Matcher matcher) {
        matchers.add(0, matcher);
    }

    public static Date convert(String input) {
        return Str2Time.convert(input, "");
    }

    public static Date convert(String input, String refDateStr) {
        for (Matcher matcher : matchers) {
            Date date = matcher.tryConvert(input, refDateStr);
            if (date == null) continue;
            return date;
        }
        return null;
    }

    private Str2Time() {
        throw new UnsupportedOperationException("cannot instantiate");
    }

    static {
        matchers.add(new NowMatcher());
        matchers.add(new TomorrowMatcher());
        matchers.add(new YesterdayMatcher());
        matchers.add(new DaysMatcher());
        matchers.add(new WeeksMatcher());
        matchers.add(new MinutesMatcher());
        matchers.add(new DateFormatMatcher(new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ")));
        matchers.add(new DateFormatMatcher(new SimpleDateFormat("yyyy.MM.dd G 'at' HH:mm:ss z")));
        matchers.add(new DateFormatMatcher(new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss Z")));
        matchers.add(new DateFormatMatcher(new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss")));
        matchers.add(new DateFormatMatcher(new SimpleDateFormat("yyyy MM dd")));
        matchers.add(new DateFormatMatcher(new SimpleDateFormat("EEE MMM d HH:mm:ss Z yyyy")));
    }
}

