/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiservletframework.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.security.Principal;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.servlet.AsyncContext;
import javax.servlet.DispatcherType;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpUpgradeHandler;
import javax.servlet.http.Part;

public class MockHttpServletRequest
implements HttpServletRequest {
    final String method;
    protected Map<String, Object> attributes = new HashMap<String, Object>();
    protected String contextPath = null;
    protected Map<String, String[]> headers = new HashMap<String, String[]>();
    protected Cookie[] cookies = new Cookie[0];
    protected Locale locale = null;
    protected Map<String, String[]> parameters = new HashMap<String, String[]>();
    protected String pathInfo = null;
    protected Principal principal = null;
    protected String queryString = null;
    protected String servletPath = null;
    protected HttpSession session = null;

    public MockHttpServletRequest(String method) {
        this.method = method;
    }

    public MockHttpServletRequest(HttpSession session) {
        this.method = "GET";
        this.setHttpSession(session);
    }

    public void addHeader(String name, String value) {
        String[] values = this.headers.get(name);
        if (values == null) {
            String[] results = new String[]{value};
            this.headers.put(name, results);
            return;
        }
        String[] results = new String[values.length + 1];
        System.arraycopy(values, 0, results, 0, values.length);
        results[values.length] = value;
        this.headers.put(name, results);
    }

    public void addParameter(String name, String value) {
        String[] values = this.parameters.get(name);
        if (values == null) {
            String[] results = new String[]{value};
            this.parameters.put(name, results);
            return;
        }
        String[] results = new String[values.length + 1];
        System.arraycopy(values, 0, results, 0, values.length);
        results[values.length] = value;
        this.parameters.put(name, results);
    }

    public void addCookie(String name, String value) {
        this.addCookie(new Cookie(name, value));
    }

    public void addCookie(Cookie cookie) {
        Cookie[] newValues = new Cookie[this.cookies.length + 1];
        System.arraycopy(this.cookies, 0, newValues, 0, this.cookies.length);
        this.cookies = newValues;
        this.cookies[this.cookies.length - 1] = cookie;
    }

    public void setHttpSession(HttpSession session) {
        this.session = session;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public void setServletPath(String servletPath) {
        this.servletPath = servletPath;
    }

    public void setUserPrincipal(Principal principal) {
        this.principal = principal;
    }

    public String getAuthType() {
        throw new UnsupportedOperationException();
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public Cookie[] getCookies() {
        return this.cookies;
    }

    public long getDateHeader(String name) {
        if (this.headers.containsKey(name)) {
            String[] values = this.headers.get(name);
            if (values.length == 0) {
                return -1L;
            }
            try {
                return Long.valueOf(values[0]);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException();
            }
        }
        return -1L;
    }

    public String getHeader(String name) {
        String[] values = this.headers.get(name);
        if (values != null) {
            return values[0];
        }
        return null;
    }

    public int getIntHeader(String name) {
        throw new UnsupportedOperationException();
    }

    public String getMethod() {
        return this.method;
    }

    public String getPathInfo() {
        return this.pathInfo;
    }

    public String getPathTranslated() {
        throw new UnsupportedOperationException();
    }

    public String getQueryString() {
        return this.queryString;
    }

    public String getRemoteUser() {
        if (this.principal != null) {
            return this.principal.getName();
        }
        return null;
    }

    public String getRequestedSessionId() {
        throw new UnsupportedOperationException();
    }

    public String getRequestURI() {
        StringBuffer sb = new StringBuffer();
        if (this.contextPath != null) {
            sb.append(this.contextPath);
        }
        if (this.servletPath != null) {
            sb.append(this.servletPath);
        }
        if (this.pathInfo != null) {
            sb.append(this.pathInfo);
        }
        if (sb.length() > 0) {
            return sb.toString();
        }
        throw new UnsupportedOperationException();
    }

    public StringBuffer getRequestURL() {
        throw new UnsupportedOperationException();
    }

    public String getServletPath() {
        return this.servletPath;
    }

    public HttpSession getSession() {
        return this.getSession(true);
    }

    public HttpSession getSession(boolean create) {
        return null;
    }

    public Principal getUserPrincipal() {
        return this.principal;
    }

    public boolean isRequestedSessionIdFromCookie() {
        throw new UnsupportedOperationException();
    }

    public boolean isRequestedSessionIdFromUrl() {
        throw new UnsupportedOperationException();
    }

    public boolean isRequestedSessionIdFromURL() {
        throw new UnsupportedOperationException();
    }

    public boolean isRequestedSessionIdValid() {
        throw new UnsupportedOperationException();
    }

    public boolean isUserInRole(String role) {
        throw new UnsupportedOperationException();
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public String getCharacterEncoding() {
        throw new UnsupportedOperationException();
    }

    public int getContentLength() {
        throw new UnsupportedOperationException();
    }

    public String getContentType() {
        throw new UnsupportedOperationException();
    }

    public ServletInputStream getInputStream() {
        throw new UnsupportedOperationException();
    }

    public Locale getLocale() {
        return this.locale;
    }

    public Enumeration<Locale> getLocales() {
        throw new UnsupportedOperationException();
    }

    public String getLocalAddr() {
        throw new UnsupportedOperationException();
    }

    public String getLocalName() {
        throw new UnsupportedOperationException();
    }

    public int getLocalPort() {
        throw new UnsupportedOperationException();
    }

    public String getParameter(String name) {
        String[] values = this.parameters.get(name);
        if (values != null) {
            return values[0];
        }
        return null;
    }

    public Map<String, String[]> getParameterMap() {
        return this.parameters;
    }

    public String[] getParameterValues(String name) {
        return this.parameters.get(name);
    }

    public String getProtocol() {
        throw new UnsupportedOperationException();
    }

    public BufferedReader getReader() {
        throw new UnsupportedOperationException();
    }

    public String getRealPath(String path) {
        throw new UnsupportedOperationException();
    }

    public String getRemoteAddr() {
        throw new UnsupportedOperationException();
    }

    public String getRemoteHost() {
        throw new UnsupportedOperationException();
    }

    public int getRemotePort() {
        throw new UnsupportedOperationException();
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        throw new UnsupportedOperationException();
    }

    public String getScheme() {
        return "http";
    }

    public String getServerName() {
        return "localhost";
    }

    public int getServerPort() {
        return 8080;
    }

    public boolean isSecure() {
        return false;
    }

    public void removeAttribute(String name) {
        this.attributes.remove(name);
    }

    public void setAttribute(String name, Object value) {
        if (value == null) {
            this.attributes.remove(name);
        } else {
            this.attributes.put(name, value);
        }
    }

    public void setCharacterEncoding(String name) {
        throw new UnsupportedOperationException();
    }

    public Enumeration<String> getAttributeNames() {
        throw new UnsupportedOperationException();
    }

    public Enumeration<String> getParameterNames() {
        throw new UnsupportedOperationException();
    }

    public Enumeration<String> getHeaderNames() {
        throw new UnsupportedOperationException();
    }

    public Enumeration<String> getHeaders(String arg0) {
        throw new UnsupportedOperationException();
    }

    public AsyncContext getAsyncContext() {
        return null;
    }

    public DispatcherType getDispatcherType() {
        return null;
    }

    public ServletContext getServletContext() {
        return null;
    }

    public boolean isAsyncStarted() {
        return false;
    }

    public boolean isAsyncSupported() {
        return false;
    }

    public AsyncContext startAsync() {
        return null;
    }

    public AsyncContext startAsync(ServletRequest arg0, ServletResponse arg1) {
        return null;
    }

    public boolean authenticate(HttpServletResponse arg0) throws IOException, ServletException {
        return false;
    }

    public Part getPart(String arg0) throws IOException, IllegalStateException, ServletException {
        return null;
    }

    public Collection<Part> getParts() throws IOException, IllegalStateException, ServletException {
        return null;
    }

    public void login(String arg0, String arg1) throws ServletException {
    }

    public void logout() throws ServletException {
    }

    public long getContentLengthLong() {
        return 0L;
    }

    public String changeSessionId() {
        return null;
    }

    public <T extends HttpUpgradeHandler> T upgrade(Class<T> arg0) throws IOException, ServletException {
        return null;
    }
}

