/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiservletframework.utils;

import com.neptunelabs.fsiframework.helpers.FileEventCallback;
import com.neptunelabs.fsiframework.io.FileEventCursor;
import com.neptunelabs.fsiframework.logging.FSILogger;
import com.neptunelabs.fsiservletframework.ExtendedServlet;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Path;
import java.util.List;

public class ServletFileEventCursor
extends FileEventCursor {
    volatile boolean restarting = false;

    public ServletFileEventCursor(FSILogger logger) throws IOException {
        super(logger);
    }

    public synchronized RegisteredPathServlet addPathMonitor(Path path, List<FileEventCallback> callbacks, List<ExtendedServlet> restartableServlets) throws IOException {
        RegisteredPathServlet rp = (RegisteredPathServlet)super.addPathMonitor(path, callbacks);
        if (restartableServlets != null) {
            for (ExtendedServlet servlet : restartableServlets) {
                rp.addRestartableServlet(servlet);
            }
        }
        return rp;
    }

    public synchronized RegisteredPathServlet addPathMonitor(Path path, DirectoryStream.Filter<Path> filter, boolean recursive, List<FileEventCallback> callbacks, List<ExtendedServlet> restartableServlets) throws IOException {
        RegisteredPathServlet rp = (RegisteredPathServlet)super.addPathMonitor(path, filter, recursive, callbacks);
        if (restartableServlets != null) {
            for (ExtendedServlet servlet : restartableServlets) {
                rp.addRestartableServlet(servlet);
            }
        }
        return rp;
    }

    public boolean isRestarting() {
        return this.restarting;
    }

    public class RegisteredPathServlet
    extends FileEventCursor.RegisteredPath {
        List<ExtendedServlet> restartableServlets;

        public void addRestartableServlet(ExtendedServlet servlets) {
            this.restartableServlets.add(servlets);
        }

        @Override
        public void changedPath(List<FileEventCallback> callbackToFire) {
            super.changedPath(callbackToFire);
            if (this.restartableServlets != null) {
                ServletFileEventCursor.this.restarting = true;
                for (ExtendedServlet servlet : this.restartableServlets) {
                    servlet.stop();
                    servlet.start();
                }
                ServletFileEventCursor.this.restarting = false;
            }
        }
    }
}

