/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiservletframework.utils;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;

public class ThreadLocalsCleaner {
    public static void removeThreadLocals() {
        Thread[] threads = ThreadLocalsCleaner.getThreads();
        try {
            Field threadLocalsField = Thread.class.getDeclaredField("threadLocals");
            threadLocalsField.setAccessible(true);
            Field inheritableThreadLocalsField = Thread.class.getDeclaredField("inheritableThreadLocals");
            inheritableThreadLocalsField.setAccessible(true);
            Class<?> tlmClass = Class.forName("java.lang.ThreadLocal$ThreadLocalMap");
            Field tableField = tlmClass.getDeclaredField("table");
            tableField.setAccessible(true);
            for (int i = 0; i < threads.length; ++i) {
                if (threads[i] == null) continue;
                Object threadLocalMap = threadLocalsField.get(threads[i]);
                ThreadLocalsCleaner.clearThreadLocalMap(threadLocalMap, tableField);
                threadLocalMap = inheritableThreadLocalsField.get(threads[i]);
                ThreadLocalsCleaner.clearThreadLocalMap(threadLocalMap, tableField);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static Thread[] getThreads() {
        ThreadGroup tg = Thread.currentThread().getThreadGroup();
        while (tg.getParent() != null) {
            tg = tg.getParent();
        }
        int threadCountGuess = tg.activeCount() + 50;
        Thread[] threads = new Thread[threadCountGuess];
        int threadCountActual = tg.enumerate(threads);
        while (threadCountActual == threadCountGuess) {
            threads = new Thread[threadCountGuess *= 2];
            threadCountActual = tg.enumerate(threads);
        }
        return threads;
    }

    private static void clearThreadLocalMap(Object map, Field internalTableField) throws NoSuchMethodException, IllegalAccessException, NoSuchFieldException, InvocationTargetException {
        if (map != null) {
            Method mapRemove = map.getClass().getDeclaredMethod("remove", ThreadLocal.class);
            mapRemove.setAccessible(true);
            Object[] table = (Object[])internalTableField.get(map);
            if (table != null) {
                for (int j = 0; j < table.length; ++j) {
                    if (table[j] == null) continue;
                    Field valueField = table[j].getClass().getDeclaredField("value");
                    valueField.setAccessible(true);
                    Object value = valueField.get(table[j]);
                    if (value == null || !(value instanceof HashMap)) continue;
                    ((HashMap)value).clear();
                }
            }
        }
    }
}

