/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiservletframework.utils;

import com.neptunelabs.fsiframework.helpers.Inet6AddressUtils;
import java.io.IOException;
import java.net.Inet6Address;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.StringTokenizer;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;

public abstract class URL {
    private URL() {
    }

    public static byte[] getContent(HttpServletRequest req) throws IOException {
        byte[] data = new byte[req.getContentLength()];
        int len = 0;
        try (ServletInputStream is = req.getInputStream();){
            for (int totalLen = 0; totalLen < data.length; totalLen += len) {
                len = is.read(data, totalLen, data.length - totalLen);
                if (len != -1) continue;
                break;
            }
        }
        return data;
    }

    public static Map<String, String[]> parseParameters(byte[] data, Charset charset) {
        HashMap<String, String[]> map = new HashMap<String, String[]>(data.length / 3 + 1);
        if (data.length > 0) {
            int ix = 0;
            int ox = 0;
            String key = null;
            String value = null;
            block6: while (ix < data.length) {
                byte c = data[ix++];
                switch ((char)c) {
                    case '&': {
                        value = new String(data, 0, ox, charset);
                        if (key != null) {
                            URL.putMapEntry(map, key, value);
                            key = null;
                        }
                        ox = 0;
                        continue block6;
                    }
                    case '=': {
                        if (key == null) {
                            key = new String(data, 0, ox, charset);
                            ox = 0;
                            continue block6;
                        }
                        data[ox++] = c;
                        continue block6;
                    }
                    case '+': {
                        data[ox++] = 32;
                        continue block6;
                    }
                    case '%': {
                        data[ox++] = (byte)((URL.convertHexDigit(data[ix++]) << 4) + URL.convertHexDigit(data[ix++]));
                        continue block6;
                    }
                }
                data[ox++] = c;
            }
            if (key != null) {
                value = new String(data, 0, ox, charset);
                URL.putMapEntry(map, key, value);
            }
        }
        return map;
    }

    private static byte convertHexDigit(byte b) {
        if (b >= 48 && b <= 57) {
            return (byte)(b - 48);
        }
        if (b >= 97 && b <= 102) {
            return (byte)(b - 97 + 10);
        }
        if (b >= 65 && b <= 70) {
            return (byte)(b - 65 + 10);
        }
        throw new IllegalArgumentException("no hex value" + Character.valueOf((char)b));
    }

    private static void putMapEntry(Map<String, String[]> map, String name, String value) {
        String[] newValues = null;
        String[] oldValues = map.get(name);
        if (oldValues == null) {
            newValues = new String[]{value};
        } else {
            newValues = new String[oldValues.length + 1];
            System.arraycopy(oldValues, 0, newValues, 0, oldValues.length);
            newValues[oldValues.length] = value;
        }
        map.put(name, newValues);
    }

    public static String cleanUpSourceParameter(String sourcepath) {
        return URL.cleanUpSourceParameter(sourcepath, null);
    }

    public static String cleanUpSourceParameter(String sourcepath, String endAppend) {
        String sourcepathVal = sourcepath.trim();
        StringBuilder sb = new StringBuilder();
        if (sourcepathVal != null) {
            if (sourcepathVal.length() == 0 || sourcepathVal.equals("/")) {
                sb.append('/');
            }
            int maxPathComponents = 255;
            LinkedList<String> pathList = new LinkedList<String>();
            StringTokenizer st = new StringTokenizer(sourcepathVal, "/");
            while (st.hasMoreTokens() && maxPathComponents-- > 0) {
                String pathToken = st.nextToken();
                if (pathToken.equals("..")) {
                    if (pathList.size() <= 0) continue;
                    pathList.removeLast();
                    continue;
                }
                if (pathToken.equals(".") || pathToken.equals("")) continue;
                pathList.add(pathToken);
            }
            int pathLength = pathList.size();
            for (int p = 0; p < pathLength; ++p) {
                sb.append((String)pathList.get(p));
                if (p + 1 >= pathLength) continue;
                sb.append('/');
            }
            if (endAppend != null) {
                if (endAppend.equals("/") && pathList.size() > 0) {
                    sb.append(endAppend);
                } else if (!endAppend.equals("/")) {
                    sb.append(endAppend);
                }
            }
        }
        return sb.toString();
    }

    public static final String getParentAssetURLPath(String assetURLPath) {
        StringBuilder resultBuilder = new StringBuilder();
        String assetURLPathVal = assetURLPath.endsWith("/") ? assetURLPath.substring(0, assetURLPath.length() - 1) : assetURLPath;
        StringTokenizer st = new StringTokenizer(assetURLPathVal, "/");
        int tokenCount = st.countTokens();
        for (int i = 0; i < tokenCount - 1; ++i) {
            resultBuilder.append(st.nextToken());
            resultBuilder.append("/");
        }
        return URL.cleanUpSourceParameter(resultBuilder.toString());
    }

    public static String getURLCompatibleHostname(String hostname) {
        String result = hostname;
        Inet6Address ipv6address = Inet6AddressUtils.parseInet6AddressString(hostname);
        if (ipv6address != null) {
            result = "[" + ipv6address.getHostAddress() + "]";
        }
        return result;
    }
}

