/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiservletframework.webinterface;

import com.neptunelabs.fsiservletframework.webinterface.AuthorizationLevel;
import com.neptunelabs.fsiservletframework.webinterface.MenuEntry;
import freemarker.template.SimpleHash;
import freemarker.template.SimpleSequence;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public final class Menu {
    private String enabledClassNameTopMenu = null;
    private String disabledClassNameTopMenu = null;
    private String enabledClassNameMainMenu = null;
    private String disabledClassNameMainMenu = null;
    private Map<String, Map<String, MenuEntry>> topmenu = new HashMap<String, Map<String, MenuEntry>>();
    private Map<String, Map<String, MenuEntry>> iconmenu = new HashMap<String, Map<String, MenuEntry>>();
    private Map<String, Map<String, MenuEntry>> mainmenu = new HashMap<String, Map<String, MenuEntry>>();

    public void initTopMenuCSS(String enabledClassName, String disabledClassName) {
        this.enabledClassNameTopMenu = enabledClassName;
        this.disabledClassNameTopMenu = disabledClassName;
    }

    public void initMainMenuCSS(String enabledClassName, String disabledClassName) {
        this.enabledClassNameMainMenu = enabledClassName;
        this.disabledClassNameMainMenu = disabledClassName;
    }

    public void putTopMenuEntry(String subMenuName, boolean enabled, AuthorizationLevel level, String name, String link) {
        this.putMenuEntry(this.topmenu, subMenuName, enabled, level, name, link, null, null, null, 0);
    }

    public void putIconMenuEntry(String subMenuName, boolean enabled, AuthorizationLevel level, String title, String link, String image, String imageHover, String imageDown) {
        this.putMenuEntry(this.iconmenu, subMenuName, enabled, level, title, link, image, imageHover, imageDown, 0);
    }

    public void putMainMenuEntry(String subMenuName, boolean enabled, AuthorizationLevel level, String name, String link, int indent) {
        this.putMenuEntry(this.mainmenu, subMenuName, enabled, level, name, link, null, null, null, indent);
    }

    public void putMainMenuEntry(String subMenuName, boolean enabled, AuthorizationLevel level, String name, String link) {
        this.putMenuEntry(this.mainmenu, subMenuName, enabled, level, name, link, null, null, null, 0);
    }

    public void disableIconMenuEntry(String subMenuName, String name, boolean disabled) {
        this.disableMenuEntry(this.iconmenu, subMenuName, name, disabled);
    }

    public SimpleSequence getTopMenu(String subMenuName) {
        return this.getMenu(this.topmenu, subMenuName, this.enabledClassNameTopMenu, this.disabledClassNameTopMenu);
    }

    public SimpleSequence getIconMenu(String subMenuName) {
        return this.getMenu(this.iconmenu, subMenuName, null, null);
    }

    public SimpleSequence getMainMenu(String subMenuName) {
        return this.getMenu(this.mainmenu, subMenuName, this.enabledClassNameMainMenu, this.disabledClassNameMainMenu);
    }

    private void putMenuEntry(Map<String, Map<String, MenuEntry>> menu, String subMenuName, boolean enabled, AuthorizationLevel level, String name, String link, String image, String imageHover, String imageDown, int indent) {
        Map<String, MenuEntry> submenu = menu.get(subMenuName);
        if (submenu == null) {
            submenu = new LinkedHashMap<String, MenuEntry>();
        }
        MenuEntry menuentry = new MenuEntry(enabled, level, name, link, image, imageHover, imageDown, indent);
        submenu.put(name, menuentry);
        menu.put(subMenuName, submenu);
    }

    private SimpleSequence getMenu(Map<String, Map<String, MenuEntry>> menu, String subMenuName, String enabledClassName, String disabledClassName) {
        SimpleSequence retmenu = new SimpleSequence();
        Map<String, MenuEntry> submenu = menu.get(subMenuName);
        for (Map.Entry<String, MenuEntry> entry : submenu.entrySet()) {
            retmenu.add((Object)this.fillEntry(entry.getValue(), enabledClassName, disabledClassName));
        }
        return retmenu;
    }

    private SimpleHash fillEntry(MenuEntry entry, String enabledClassName, String disabledClassName) {
        SimpleHash menuentry = new SimpleHash();
        menuentry.put("enabled", entry.getEnabled());
        menuentry.put("level", (Object)entry.getLevel());
        menuentry.put("name", (Object)entry.getName());
        menuentry.put("link", (Object)entry.getLink());
        menuentry.put("image", (Object)entry.getImage());
        menuentry.put("imageHover", (Object)entry.getImageHover());
        menuentry.put("imageDown", (Object)entry.getImageDown());
        menuentry.put("classEnabled", (Object)enabledClassName);
        menuentry.put("classDisabled", (Object)disabledClassName);
        menuentry.put("indent", (Object)entry.getIndent());
        return menuentry;
    }

    private void disableMenuEntry(Map<String, Map<String, MenuEntry>> menu, String subMenuName, String name, boolean disabled) {
        Map<String, MenuEntry> submenu = menu.get(subMenuName);
        if (submenu != null) {
            MenuEntry menuentry = submenu.get(name);
            menuentry.setEnabled(!disabled);
        }
    }
}

