/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.imageio;

import com.neptunelabs.fsiframework.io.FileOperations;
import com.neptunelabs.fsiframework.logging.FSILogger;
import java.io.BufferedReader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;

public class MimeTypesLoader {
    private final FSILogger logger;
    private final Map<String, String> mimeTypeMapping;
    private static final String[] validMimes = new String[]{"image/tiff", "image/jpeg", "image/gif", "image/png", "image/vnd.fpx", "image/vnd.eis", "image/bmp"};

    public MimeTypesLoader(FSILogger logger) {
        this.logger = logger;
        this.mimeTypeMapping = new HashMap<String, String>();
    }

    public void loadFromFile(Path path) {
        this.mimeTypeMapping.clear();
        if (Files.exists(path, new LinkOption[0])) {
            try (BufferedReader reader = Files.newBufferedReader(path, FileOperations.charsetASCII);){
                String line;
                while ((line = reader.readLine()) != null) {
                    String trimLine = line.trim();
                    if (trimLine.equals("") || trimLine.startsWith("#") || trimLine.startsWith("//") || trimLine.startsWith(";")) continue;
                    String[] rawLine = trimLine.split("\\s");
                    String mimeType = rawLine[0].toLowerCase();
                    if (this.validMime(mimeType) && rawLine.length > 1) {
                        for (int x = 1; x < rawLine.length; ++x) {
                            if (rawLine[x].equals("")) continue;
                            String suffix = rawLine[x].toLowerCase();
                            this.mimeTypeMapping.put(suffix, mimeType);
                        }
                        continue;
                    }
                    this.logger.log(3842, mimeType);
                    break;
                }
                this.logger.log(3840, this.mimeTypeMapping.size());
            }
            catch (Exception e) {
                this.logger.log(3843, e.getLocalizedMessage());
            }
        } else {
            this.logger.log(3843, path.toAbsolutePath().toString());
        }
    }

    public Map<String, String> getMimeTypes() {
        return this.mimeTypeMapping;
    }

    private boolean validMime(String mime) {
        for (int c = 0; c < validMimes.length; ++c) {
            if (!validMimes[c].equalsIgnoreCase(mime)) continue;
            return true;
        }
        return false;
    }
}

