/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.imageio;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import javax.imageio.stream.ImageInputStreamImpl;

public final class SeekableByteChannelImageInputStream
extends ImageInputStreamImpl {
    private SeekableByteChannel channel;

    public SeekableByteChannelImageInputStream(Path path) throws IOException {
        long channelPosition;
        if (path == null) {
            throw new IllegalArgumentException("path == null");
        }
        this.channel = Files.newByteChannel(path, StandardOpenOption.READ);
        this.streamPos = this.flushedPos = (channelPosition = this.channel.position());
    }

    @Override
    public int read() throws IOException {
        this.checkClosed();
        this.bitOffset = 0;
        ByteBuffer dst = ByteBuffer.allocate(1);
        if (this.channel.read(dst) != -1) {
            dst.flip();
            int value = dst.get() & 0xFF;
            ++this.streamPos;
            return value;
        }
        return -1;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (off < 0 || len < 0 || off + len > b.length) {
            throw new IndexOutOfBoundsException("off < 0 || len < 0 || off + len > b.length");
        }
        if (len == 0) {
            return 0;
        }
        this.checkClosed();
        this.bitOffset = 0;
        ByteBuffer dst = ByteBuffer.wrap(b, off, len);
        if (this.channel.read(dst) != -1) {
            this.streamPos += (long)len;
            return len;
        }
        return -1;
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.channel.close();
        this.channel = null;
    }

    @Override
    public void readFully(char[] c, int off, int len) throws IOException {
        if (off < 0 || len < 0 || off + len > c.length) {
            throw new IndexOutOfBoundsException("off < 0 || len < 0 || off + len > c.length");
        }
        if (len == 0) {
            return;
        }
        int byteLen = 2 * len;
        ByteBuffer dst = ByteBuffer.allocateDirect(byteLen);
        dst.order(super.getByteOrder());
        if (this.channel.read(dst) != -1) {
            dst.flip();
            CharBuffer viewBuffer = dst.asCharBuffer();
            viewBuffer.get(c, off, len);
            this.streamPos += (long)byteLen;
        }
    }

    @Override
    public void readFully(short[] s, int off, int len) throws IOException {
        if (off < 0 || len < 0 || off + len > s.length) {
            throw new IndexOutOfBoundsException("off < 0 || len < 0 || off + len > s.length");
        }
        if (len == 0) {
            return;
        }
        int byteLen = 2 * len;
        ByteBuffer dst = ByteBuffer.allocateDirect(byteLen);
        dst.order(super.getByteOrder());
        if (this.channel.read(dst) != -1) {
            dst.flip();
            ShortBuffer viewBuffer = dst.asShortBuffer();
            viewBuffer.get(s, off, len);
            this.streamPos += (long)byteLen;
        }
    }

    @Override
    public void readFully(int[] i, int off, int len) throws IOException {
        if (off < 0 || len < 0 || off + len > i.length) {
            throw new IndexOutOfBoundsException("off < 0 || len < 0 || off + len > i.length");
        }
        if (len == 0) {
            return;
        }
        int byteLen = 4 * len;
        ByteBuffer dst = ByteBuffer.allocateDirect(byteLen);
        dst.order(super.getByteOrder());
        if (this.channel.read(dst) != -1) {
            dst.flip();
            IntBuffer viewBuffer = dst.asIntBuffer();
            viewBuffer.get(i, off, len);
            this.streamPos += (long)byteLen;
        }
    }

    @Override
    public void readFully(long[] l, int off, int len) throws IOException {
        if (off < 0 || len < 0 || off + len > l.length) {
            throw new IndexOutOfBoundsException("off < 0 || len < 0 || off + len > l.length");
        }
        if (len == 0) {
            return;
        }
        int byteLen = 8 * len;
        ByteBuffer dst = ByteBuffer.allocateDirect(byteLen);
        dst.order(super.getByteOrder());
        if (this.channel.read(dst) != -1) {
            dst.flip();
            LongBuffer viewBuffer = dst.asLongBuffer();
            viewBuffer.get(l, off, len);
            this.streamPos += (long)byteLen;
        }
    }

    @Override
    public void readFully(float[] f, int off, int len) throws IOException {
        if (off < 0 || len < 0 || off + len > f.length) {
            throw new IndexOutOfBoundsException("off < 0 || len < 0 || off + len > f.length");
        }
        if (len == 0) {
            return;
        }
        int byteLen = 4 * len;
        ByteBuffer dst = ByteBuffer.allocateDirect(byteLen);
        dst.order(super.getByteOrder());
        if (this.channel.read(dst) != -1) {
            dst.flip();
            FloatBuffer viewBuffer = dst.asFloatBuffer();
            viewBuffer.get(f, off, len);
            this.streamPos += (long)byteLen;
        }
    }

    @Override
    public void readFully(double[] d, int off, int len) throws IOException {
        if (off < 0 || len < 0 || off + len > d.length) {
            throw new IndexOutOfBoundsException("off < 0 || len < 0 || off + len > d.length");
        }
        if (len == 0) {
            return;
        }
        int byteLen = 8 * len;
        ByteBuffer dst = ByteBuffer.allocateDirect(byteLen);
        dst.order(super.getByteOrder());
        if (this.channel.read(dst) != -1) {
            dst.flip();
            DoubleBuffer viewBuffer = dst.asDoubleBuffer();
            viewBuffer.get(d, off, len);
            this.streamPos += (long)byteLen;
        }
    }

    @Override
    public long length() {
        long length = -1L;
        try {
            length = this.channel.size();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return length;
    }

    @Override
    public void seek(long pos) throws IOException {
        super.seek(pos);
        this.channel.position(pos);
    }

    @Override
    public void setByteOrder(ByteOrder networkByteOrder) {
        super.setByteOrder(networkByteOrder);
    }
}

