/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.imagemanipulator.anaglyph;

import com.neptunelabs.fsiframework.helpers.ExecutorPool;
import com.neptunelabs.fsiframework.helpers.ProcessingException;
import com.neptunelabs.fsiframework.logging.FSILogger;
import com.neptunelabs.imagemanipulator.anaglyph.InterlaceMode;
import com.neptunelabs.imagemanipulator.area.LayerBlend;
import com.neptunelabs.imagemanipulator.color.BlendMode;
import com.neptunelabs.imagemanipulator.color.ChannelRGBFilter;
import com.neptunelabs.imagemanipulator.color.ColorOperatorImpl;
import com.neptunelabs.imagemanipulator.color.ParallelColorOperation;
import com.neptunelabs.imagereader.image.FSIImage;
import java.util.ArrayList;

public class AnaglyphRenderer {
    private final FSILogger logger;
    private final ExecutorPool executorPool;
    private FSIImage leftImage = null;
    private int leftColor = 0xFFFFFF;
    private FSIImage rightImage = null;
    private int rightColor = 0xFFFFFF;
    private InterlaceMode interlaceMode = InterlaceMode.None;

    public AnaglyphRenderer(FSILogger logger, ExecutorPool executorPool) {
        this.logger = logger;
        this.executorPool = executorPool;
    }

    public FSIImage render(int priority, boolean keepImages) throws ProcessingException {
        FSIImage result = null;
        try {
            if (this.interlaceMode == InterlaceMode.None) {
                ParallelColorOperation pColorOperation;
                ChannelRGBFilter filter;
                ArrayList<ColorOperatorImpl> colorOps;
                if ((this.leftColor & 0xFFFFFF) != 0xFFFFFF) {
                    colorOps = new ArrayList<ColorOperatorImpl>();
                    filter = new ChannelRGBFilter(this.leftColor & 0xFFFFFF);
                    colorOps.add(filter);
                    pColorOperation = new ParallelColorOperation(this.logger, this.executorPool, priority);
                    this.leftImage = pColorOperation.transform(this.leftImage, colorOps, false);
                }
                if ((this.rightColor & 0xFFFFFF) != 0xFFFFFF) {
                    colorOps = new ArrayList();
                    filter = new ChannelRGBFilter(this.rightColor & 0xFFFFFF);
                    colorOps.add(filter);
                    pColorOperation = new ParallelColorOperation(this.logger, this.executorPool, priority);
                    this.rightImage = pColorOperation.transform(this.rightImage, colorOps, false);
                }
                LayerBlend blend = new LayerBlend(this.logger, this.executorPool, priority);
                result = blend.transform(this.leftImage, this.rightImage, 0, 0, BlendMode.LINEARDODGEADD, 100.0f, true);
            } else {
                result = this.leftImage.createCompatibleImage();
                int width = result.getWidth();
                int height = result.getHeight();
                int mod = 0;
                switch (this.interlaceMode) {
                    case HorizontalL: {
                        mod = 1;
                    }
                    case HorizontalR: {
                        for (int y = 0; y < height; ++y) {
                            for (int x = 0; x < width; ++x) {
                                if (mod == 0) {
                                    result.setSample(this.leftImage.getSample(x, y));
                                    continue;
                                }
                                result.setSample(this.rightImage.getSample(x, y));
                            }
                            if (++mod != 2) continue;
                            mod = 0;
                        }
                        break;
                    }
                    case VerticalL: {
                        mod = 1;
                    }
                    case VerticalR: {
                        for (int x = 0; x < width; ++x) {
                            for (int y = 0; y < height; ++y) {
                                if (mod == 0) {
                                    result.setSample(this.leftImage.getSample(x, y));
                                    continue;
                                }
                                result.setSample(this.rightImage.getSample(x, y));
                            }
                            if (++mod != 2) continue;
                            mod = 0;
                        }
                        break;
                    }
                }
            }
            if (!keepImages) {
                this.leftImage.dispose();
                this.rightImage.dispose();
            }
        }
        catch (ProcessingException e) {
            if (this.leftImage != null) {
                this.leftImage.dispose();
            }
            if (this.rightImage != null) {
                this.rightImage.dispose();
            }
            throw e;
        }
        return result;
    }

    public void setImages(FSIImage imageLeft, FSIImage imageRight) {
        this.leftImage = imageLeft;
        this.rightImage = imageRight;
    }

    public void setLeftColor(int leftColor) {
        this.leftColor = leftColor;
        this.interlaceMode = InterlaceMode.None;
    }

    public void setRightColor(int rightColor) {
        this.rightColor = rightColor;
        this.interlaceMode = InterlaceMode.None;
    }

    public void setInterlaceMode(InterlaceMode mode) {
        this.interlaceMode = mode;
    }
}

