/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.imagemanipulator.area;

import com.neptunelabs.fsiframework.helpers.ExecutorPool;
import com.neptunelabs.fsiframework.logging.FSILogger;
import com.neptunelabs.imagemanipulator.utils.BaseImageUtils;
import com.neptunelabs.imagemanipulator.utils.EffectUtils;
import com.neptunelabs.imagereader.image.FSIImage;

public class BlurFast
extends EffectUtils {
    public BlurFast(FSILogger logger, ExecutorPool executorPool, int priority) {
        super(logger, executorPool, priority);
    }

    public FSIImage transform(FSIImage input, int iterations, float hRadius, float vRadius, boolean keepInput) {
        FSIImage buffer1 = input.createCopy();
        FSIImage buffer2 = input.createCompatibleImage();
        if (!keepInput) {
            input.dispose();
        }
        int width = input.getWidth();
        int height = input.getHeight();
        for (int i = 0; i < iterations; ++i) {
            this.blur(buffer1, buffer2, width, height, hRadius);
            this.blur(buffer2, buffer1, height, width, vRadius);
        }
        this.blurFractional(buffer1, buffer2, width, height, hRadius);
        this.blurFractional(buffer2, buffer1, height, width, vRadius);
        buffer2.dispose();
        return buffer1;
    }

    public void blur(FSIImage input, FSIImage output, int width, int height, float radius) {
        int widthMinus1 = width - 1;
        int r = (int)radius;
        int tableSize = 2 * r + 1;
        int[] divide = new int[256 * tableSize];
        for (int i = 0; i < 256 * tableSize; ++i) {
            divide[i] = i / tableSize;
        }
        int inIndex = 0;
        for (int y = 0; y < height; ++y) {
            int outIndex = y;
            int ta = 0;
            int tr = 0;
            int tg = 0;
            int tb = 0;
            for (int i = -r; i <= r; ++i) {
                int rgb = input.getSample(inIndex + BaseImageUtils.clampFT(i, 0, width - 1));
                ta += rgb >> 24 & 0xFF;
                tr += rgb >> 16 & 0xFF;
                tg += rgb >> 8 & 0xFF;
                tb += rgb & 0xFF;
            }
            for (int x = 0; x < width; ++x) {
                int i2;
                output.setSample(outIndex, divide[ta] << 24 | divide[tr] << 16 | divide[tg] << 8 | divide[tb]);
                int i1 = x + r + 1;
                if (i1 > widthMinus1) {
                    i1 = widthMinus1;
                }
                if ((i2 = x - r) < 0) {
                    i2 = 0;
                }
                int rgb1 = input.getSample(inIndex + i1);
                int rgb2 = input.getSample(inIndex + i2);
                ta += (rgb1 >> 24 & 0xFF) - (rgb2 >> 24 & 0xFF);
                tr += (rgb1 & 0xFF0000) - (rgb2 & 0xFF0000) >> 16;
                tg += (rgb1 & 0xFF00) - (rgb2 & 0xFF00) >> 8;
                tb += (rgb1 & 0xFF) - (rgb2 & 0xFF);
                outIndex += height;
            }
            inIndex += width;
        }
    }

    public void blurFractional(FSIImage input, FSIImage output, int width, int height, float radius) {
        radius -= (float)((int)radius);
        float f = 1.0f / (1.0f + 2.0f * radius);
        int inIndex = 0;
        for (int y = 0; y < height; ++y) {
            int outIndex = y;
            output.setSample(outIndex, input.getSample(0L));
            outIndex += height;
            for (int x = 1; x < width - 1; ++x) {
                int i = inIndex + x;
                int rgb1 = input.getSample(i - 1);
                int rgb2 = input.getSample(i);
                int rgb3 = input.getSample(i + 1);
                int a1 = rgb1 >> 24 & 0xFF;
                int r1 = rgb1 >> 16 & 0xFF;
                int g1 = rgb1 >> 8 & 0xFF;
                int b1 = rgb1 & 0xFF;
                int a2 = rgb2 >> 24 & 0xFF;
                int r2 = rgb2 >> 16 & 0xFF;
                int g2 = rgb2 >> 8 & 0xFF;
                int b2 = rgb2 & 0xFF;
                int a3 = rgb3 >> 24 & 0xFF;
                int r3 = rgb3 >> 16 & 0xFF;
                int g3 = rgb3 >> 8 & 0xFF;
                int b3 = rgb3 & 0xFF;
                a1 = a2 + (int)((float)(a1 + a3) * radius);
                r1 = r2 + (int)((float)(r1 + r3) * radius);
                g1 = g2 + (int)((float)(g1 + g3) * radius);
                b1 = b2 + (int)((float)(b1 + b3) * radius);
                a1 = (int)((float)a1 * f);
                r1 = (int)((float)r1 * f);
                g1 = (int)((float)g1 * f);
                b1 = (int)((float)b1 * f);
                output.setSample(outIndex, a1 << 24 | r1 << 16 | g1 << 8 | b1);
                outIndex += height;
            }
            output.setSample(outIndex, input.getSample(width - 1));
            inIndex += width;
        }
    }
}

