/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.imagemanipulator.area;

import com.neptunelabs.fsiframework.concurrent.PriorityExecutor;
import com.neptunelabs.fsiframework.concurrent.PriorityExecutorCompletionService;
import com.neptunelabs.fsiframework.helpers.ExecutorPool;
import com.neptunelabs.fsiframework.helpers.ProcessingException;
import com.neptunelabs.fsiframework.logging.FSILogger;
import com.neptunelabs.imagemanipulator.utils.BaseImageUtils;
import com.neptunelabs.imagemanipulator.utils.EffectUtils;
import com.neptunelabs.imagereader.image.FSIImage;
import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public final class CheckerMatte
extends EffectUtils {
    public CheckerMatte(FSILogger logger, ExecutorPool executorPool, int priority) {
        super(logger, executorPool, priority);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FSIImage transform(FSIImage input, int patternSize, int color1, int color2, boolean keepInput) throws ProcessingException {
        FSIImage newImage = input.createCompatibleImage();
        if (input.hasAlpha()) {
            int threads = this.calcThreads(input);
            boolean error = false;
            PriorityExecutorCompletionService completionService = new PriorityExecutorCompletionService(this.executorPool.getExecutorService(ExecutorPool.Type.RENDERER_CPU), threads);
            ArrayList futures = new ArrayList(threads);
            for (int t = 0; t < threads; ++t) {
                RMAWorkerThread rMAWorkerThread = new RMAWorkerThread(input, newImage.createSlice(), patternSize, color1, color2, t, threads);
                futures.add(completionService.submit(rMAWorkerThread));
            }
            try {
                for (int c = 0; c < completionService.count(); ++c) {
                    completionService.take().get();
                }
            }
            catch (ExecutionException e) {
                error = true;
                throw new ProcessingException(e.getCause());
            }
            catch (InterruptedException e) {
                error = true;
            }
            finally {
                for (Future future : futures) {
                    future.cancel(true);
                }
                if (error) {
                    newImage.dispose();
                }
            }
        }
        if (!keepInput) {
            input.dispose();
        }
        return newImage;
    }

    private final class RMAWorkerThread
    implements Runnable,
    PriorityExecutor.Important {
        private final int threads;
        private final int t;
        private final FSIImage src;
        private final FSIImage target;
        private final int checkSize;
        private final int color1;
        private final int color2;

        public RMAWorkerThread(FSIImage src, FSIImage target, int checkSize, int color1, int color2, int t, int threads) {
            this.threads = threads;
            this.t = t;
            this.src = src;
            this.target = target;
            this.checkSize = checkSize;
            this.color1 = color1;
            this.color2 = color2;
        }

        @Override
        public int getPriority() {
            return CheckerMatte.this.priority;
        }

        @Override
        public void run() {
            int height = this.target.getHeight();
            int width = this.target.getWidth();
            int[] outpixels = new int[width];
            int mr1 = this.color1 >> 16 & 0xFF;
            int mg1 = this.color1 >> 8 & 0xFF;
            int mb1 = this.color1 & 0xFF;
            int mr2 = this.color2 >> 16 & 0xFF;
            int mg2 = this.color2 >> 8 & 0xFF;
            int mb2 = this.color2 & 0xFF;
            for (int y = this.t; y < height; y += this.threads) {
                for (int x = 0; x < width; ++x) {
                    int nargb;
                    int argb = this.src.getSample(x, y);
                    float af = 1.0f - (float)(argb >>> 24 & 0xFF) / 255.0f;
                    int r = argb >> 16 & 0xFF;
                    int g = argb >> 8 & 0xFF;
                    int b = argb & 0xFF;
                    int c1 = x / this.checkSize % 2 + y / this.checkSize % 2;
                    if (c1 == 1) {
                        r = BaseImageUtils.clampFT255((float)r - (float)(r - mr1) * af);
                        g = BaseImageUtils.clampFT255((float)g - (float)(g - mg1) * af);
                        b = BaseImageUtils.clampFT255((float)b - (float)(b - mb1) * af);
                    } else {
                        r = BaseImageUtils.clampFT255((float)r - (float)(r - mr2) * af);
                        g = BaseImageUtils.clampFT255((float)g - (float)(g - mg2) * af);
                        b = BaseImageUtils.clampFT255((float)b - (float)(b - mb2) * af);
                    }
                    outpixels[x] = nargb = 0xFF000000 | r << 16 | g << 8 | b;
                }
                this.target.setSamples((long)(y * width), outpixels);
            }
        }
    }
}

