/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.imagemanipulator.area;

import com.neptunelabs.imagereader.converter.FastMath;

public class ConvolutionKernel1D {
    private float[] matrix;
    private float[][] contribMatrix;
    private int[] startMatrix;

    private ConvolutionKernel1D() {
    }

    public float[] getSimpleMatrix() {
        return this.matrix;
    }

    public float[][] getShiftingMatrix() {
        return this.contribMatrix;
    }

    public int[] getStartShifting() {
        return this.startMatrix;
    }

    public static ConvolutionKernel1D getKernel(float[] matrix) {
        ConvolutionKernel1D kernel = new ConvolutionKernel1D();
        kernel.matrix = matrix;
        return kernel;
    }

    public static ConvolutionKernel1D getGaussianKernel(int radius, double sigma) {
        int r = radius;
        int rows = r * 2 + 1;
        float[] matrix = new float[rows];
        double sigma22 = 2.0 * sigma * sigma;
        double sqrtSigmaPi2 = Math.sqrt(Math.PI * 2 * sigma);
        float radius2 = radius * radius;
        float total = 0.0f;
        int index = 0;
        for (int x = -r; x <= r; ++x) {
            float distance = x * x;
            matrix[index] = distance > radius2 ? 0.0f : (float)(FastMath.exp((double)(-distance) / sigma22) / sqrtSigmaPi2);
            total += matrix[index];
            ++index;
        }
        int i = 0;
        while (i < rows) {
            int n = i++;
            matrix[n] = matrix[n] / total;
        }
        ConvolutionKernel1D kernel = new ConvolutionKernel1D();
        kernel.matrix = matrix;
        return kernel;
    }

    public static ConvolutionKernel1D buildLanczosKernel(int sourceSize, int targetSize, double centerShift, double targetOffset, double windowSize) {
        ConvolutionKernel1D kernel = new ConvolutionKernel1D();
        kernel.contribMatrix = new float[targetSize][];
        kernel.startMatrix = new int[targetSize];
        double scaleRatio = ((double)targetSize - targetOffset) / (double)sourceSize;
        double scaledRadius = windowSize / scaleRatio;
        if (scaledRadius > (double)((float)sourceSize / 2.0f)) {
            scaledRadius = (float)sourceSize / 2.0f;
        }
        if (scaleRatio > 1.0) {
            scaledRadius = windowSize;
            centerShift = scaleRatio > 5.0 ? (centerShift -= 0.5) : (centerShift -= scaleRatio / 10.0);
        } else {
            centerShift += scaledRadius / (windowSize * 2.0) - (double)targetSize / (double)sourceSize;
        }
        for (int x = 0; x < targetSize; ++x) {
            double center = (double)x / scaleRatio + centerShift;
            int start = FastMath.floor(center - scaledRadius);
            int stop = FastMath.floor(center + scaledRadius);
            int aw = stop - start;
            double weight = 0.0;
            double[] tmpKernel = new double[aw];
            int l = start;
            int p = 0;
            while (l < stop) {
                double cii;
                double pos = (center - (double)l) / (double)aw * 2.0 * windowSize;
                tmpKernel[p] = cii = ConvolutionKernel1D.lanczos(pos, windowSize);
                weight += cii;
                ++l;
                ++p;
            }
            kernel.contribMatrix[x] = new float[aw + 1];
            kernel.startMatrix[x] = start;
            for (l = 0; l < aw; ++l) {
                kernel.contribMatrix[x][l] = (float)(tmpKernel[l] / weight);
            }
        }
        return kernel;
    }

    private static double lanczos(double x, double a) {
        return Math.abs(x) < a ? ConvolutionKernel1D.sinc(x) * ConvolutionKernel1D.sinc(x / a) : 0.0;
    }

    private static double sinc(double value) {
        if (value != 0.0) {
            return Math.sin(value *= Math.PI) / value;
        }
        return 1.0;
    }
}

