/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.imagemanipulator.area;

import com.neptunelabs.imagemanipulator.utils.ImageManipulatorException;
import com.neptunelabs.imagereader.converter.FastMath;

public class ConvolutionKernel2D {
    int width;
    int height;
    float[] matrix;

    public ConvolutionKernel2D(int width, int height, float[] matrix) throws ImageManipulatorException {
        int size = width * height;
        if (width / 2 * 2 == width || height / 2 * 2 == height) {
            throw new ImageManipulatorException("Kernel size even");
        }
        if (matrix == null) {
            throw new ImageManipulatorException("Kernel matrix null");
        }
        if (size != matrix.length) {
            throw new ImageManipulatorException("Kernel must have odd width and height");
        }
        this.width = width;
        this.height = height;
        this.matrix = matrix;
    }

    public static ConvolutionKernel2D getGaussianKernel(int radius, double sigma) {
        int r = radius;
        int rows = r * 2 + 1;
        float[] matrix = new float[rows * rows];
        double sigma22 = 2.0 * sigma * sigma;
        double sqrtSigmaPi2 = Math.sqrt(Math.PI * 2 * sigma);
        float radius2 = radius * radius;
        float total = 0.0f;
        int index = 0;
        for (int x = -r; x <= r; ++x) {
            for (int y = -r; y <= r; ++y) {
                float distance = x * x + y * y;
                matrix[index] = distance > radius2 ? 0.0f : (float)(FastMath.exp((double)(-distance) / sigma22) / sqrtSigmaPi2);
                total += matrix[index];
                ++index;
            }
        }
        int i = 0;
        while (i < matrix.length) {
            int n = i++;
            matrix[n] = matrix[n] / total;
        }
        return new ConvolutionKernel2D(rows, rows, matrix);
    }
}

