/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.imagemanipulator.area;

import com.neptunelabs.fsiframework.concurrent.PriorityExecutor;
import com.neptunelabs.fsiframework.concurrent.PriorityExecutorCompletionService;
import com.neptunelabs.fsiframework.helpers.ExecutorPool;
import com.neptunelabs.fsiframework.helpers.ProcessingException;
import com.neptunelabs.fsiframework.logging.FSILogger;
import com.neptunelabs.imagemanipulator.area.ConvolutionKernel1D;
import com.neptunelabs.imagemanipulator.area.LayerBlend;
import com.neptunelabs.imagemanipulator.color.AlphaMode;
import com.neptunelabs.imagemanipulator.color.BlendMode;
import com.neptunelabs.imagemanipulator.utils.EffectUtils;
import com.neptunelabs.imagereader.helper.Selection;
import com.neptunelabs.imagereader.image.FSIImage;
import com.neptunelabs.imagereader.image.FSIImageException;
import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public final class Convolve1D
extends EffectUtils {
    public Convolve1D(FSILogger logger, ExecutorPool executorPool, int priority) {
        super(logger, executorPool, priority);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FSIImage transform(FSIImage input, ConvolutionKernel1D ckernel, boolean keepInput) throws ProcessingException {
        FSIImage result;
        block7: {
            result = null;
            int width = input.getWidth();
            int height = input.getHeight();
            float[] kernel = ckernel.getSimpleMatrix();
            FSIImage imagePass1 = null;
            FSIImage imagePass2 = null;
            try {
                imagePass1 = input.createCompatibleImage(height, width);
                boolean success = this.startFilter(input, imagePass1, kernel);
                imagePass2 = input.createCompatibleImage(width, height);
                success = this.startFilter(imagePass1, imagePass2, kernel);
                imagePass1.dispose();
                if (!success) break block7;
                if (this.alphaSelection != null) {
                    FSIImage blended = null;
                    try {
                        LayerBlend blend = new LayerBlend(this.logger, this.executorPool, this.priority);
                        blend.setSelection(new Selection(this.alphaSelection));
                        blended = blend.transform(input, imagePass2, BlendMode.NORMAL, AlphaMode.NORMAL, true);
                        break block7;
                    }
                    finally {
                        imagePass2.dispose();
                        result = blended;
                    }
                }
                result = imagePass2;
            }
            catch (ProcessingException e) {
                Convolve1D.disposeImages(result, imagePass1, imagePass2);
                throw new ProcessingException(e);
            }
        }
        if (!keepInput) {
            input.dispose();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean startFilter(FSIImage sourceImage, FSIImage targetImage, float[] kernel) throws ProcessingException {
        int threads = this.executorPool.getAvailableThreads(ExecutorPool.Type.RENDERER_CPU);
        threads = sourceImage.getHeight() < threads ? sourceImage.getHeight() : threads;
        PriorityExecutorCompletionService completionService = new PriorityExecutorCompletionService(this.executorPool.getExecutorService(ExecutorPool.Type.RENDERER_CPU), threads);
        ArrayList futures = new ArrayList(threads);
        int[][] yRanges = Convolve1D.calcThreadImageRanges(sourceImage.getHeight(), threads);
        for (int t = 0; t < threads; ++t) {
            int[] yRange = yRanges[t];
            FilteringThread filteringThread = new FilteringThread(yRange[0], yRange[1]);
            filteringThread.setImage(sourceImage.createSlice());
            filteringThread.setTargetImage(targetImage.createSlice());
            filteringThread.setKernel(kernel);
            futures.add(completionService.submit(filteringThread));
        }
        boolean error = false;
        try {
            for (int c = 0; c < completionService.count(); ++c) {
                completionService.take().get();
            }
        }
        catch (ExecutionException e) {
            error = true;
            throw new ProcessingException(e.getCause());
        }
        catch (InterruptedException e) {
            error = true;
            return error;
        }
        finally {
            for (Future future : futures) {
                future.cancel(true);
            }
        }
        return !error;
    }

    static final int clampFT(float x) {
        if (x < 0.0f) {
            return 0;
        }
        if (x > 1.0f) {
            return 255;
        }
        return (int)(x * 255.0f + 0.5f);
    }

    class FilteringThread
    implements Runnable,
    PriorityExecutor.Important {
        private final int threadStartY;
        private final int threadStopY;
        private FSIImage sourceImage;
        private FSIImage targetImage;
        private int sourceWidth;
        private int targetHeight;
        private float[] kernel;
        private volatile boolean running = false;

        public FilteringThread(int startY, int stopY) {
            this.threadStartY = startY;
            this.threadStopY = stopY;
        }

        @Override
        public int getPriority() {
            return Convolve1D.this.priority;
        }

        public void setImage(FSIImage image) {
            this.sourceImage = image;
            this.sourceWidth = image.getWidth();
        }

        public void setTargetImage(FSIImage image) {
            this.targetImage = image;
            this.targetHeight = image.getHeight();
        }

        public void setKernel(float[] kernel) {
            this.kernel = kernel;
        }

        @Override
        public void run() {
            this.running = true;
            int maxBufferSize = this.sourceWidth + this.kernel.length;
            float[] buffer = new float[maxBufferSize * 4];
            int[] intBuf = new int[this.sourceWidth];
            int halfKernelSize = this.kernel.length / 2;
            if (!this.sourceImage.hasAlpha()) {
                for (int nx = this.threadStartY; nx <= this.threadStopY && this.running; ++nx) {
                    this.fillRGBARowFloatBuffer(buffer, intBuf, this.sourceWidth, nx, -halfKernelSize, this.sourceWidth + halfKernelSize);
                    for (int ny = 0; ny < this.targetHeight; ++ny) {
                        this.targetImage.setSample(nx, ny, this.filterRGB(buffer, ny * 4, this.kernel));
                    }
                }
            } else {
                for (int nx = this.threadStartY; nx <= this.threadStopY && this.running; ++nx) {
                    this.fillRGBARowFloatBuffer(buffer, intBuf, this.sourceWidth, nx, -halfKernelSize, this.sourceWidth + halfKernelSize);
                    for (int ny = 0; ny < this.targetHeight; ++ny) {
                        this.targetImage.setSample(nx, ny, this.filterRGBA(buffer, ny * 4, this.kernel));
                    }
                }
            }
        }

        private final int filterRGB(float[] srcPixel, int inOffset, float[] contrib) {
            float pixelValueRed = 0.0f;
            float pixelValueGreen = 0.0f;
            float pixelValueBlue = 0.0f;
            int j = 0;
            int k = inOffset;
            while (j < contrib.length) {
                float p = contrib[j];
                pixelValueRed += srcPixel[k + 1] * p;
                pixelValueGreen += srcPixel[k + 2] * p;
                pixelValueBlue += srcPixel[k + 3] * p;
                ++j;
                k += 4;
            }
            return 0xFF000000 | Convolve1D.clampFT(pixelValueRed) << 16 | Convolve1D.clampFT(pixelValueGreen) << 8 | Convolve1D.clampFT(pixelValueBlue);
        }

        private final int filterRGBA(float[] srcPixel, int inOffset, float[] contrib) {
            float pixelValueAlpha = 0.0f;
            float pixelValueRed = 0.0f;
            float pixelValueGreen = 0.0f;
            float pixelValueBlue = 0.0f;
            int j = 0;
            int k = inOffset;
            while (j < contrib.length) {
                float pa = contrib[j] * srcPixel[k];
                pixelValueAlpha += pa;
                pixelValueRed += srcPixel[k + 1] * pa;
                pixelValueGreen += srcPixel[k + 2] * pa;
                pixelValueBlue += srcPixel[k + 3] * pa;
                ++j;
                k += 4;
            }
            return Convolve1D.clampFT(pixelValueAlpha) << 24 | Convolve1D.clampFT(pixelValueRed /= pixelValueAlpha) << 16 | Convolve1D.clampFT(pixelValueGreen /= pixelValueAlpha) << 8 | Convolve1D.clampFT(pixelValueBlue /= pixelValueAlpha);
        }

        private void fillRGBARowFloatBuffer(float[] buffer, int[] row, int widthVal, int y, int minX, int maxX) throws FSIImageException {
            this.sourceImage.setPosition(0, y);
            this.sourceImage.getSamples(row, 0, widthVal);
            int width1 = widthVal - 1;
            int b = 0;
            for (int x = minX; x < maxX; ++x) {
                int argb = x < 0 ? row[0] : (x >= widthVal ? row[width1] : row[x]);
                buffer[b] = (float)(argb >>> 24) / 255.0f;
                buffer[b + 1] = (float)(argb >> 16 & 0xFF) / 255.0f;
                buffer[b + 2] = (float)(argb >> 8 & 0xFF) / 255.0f;
                buffer[b + 3] = (float)(argb & 0xFF) / 255.0f;
                b += 4;
            }
        }
    }
}

