/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.imagemanipulator.area;

import com.neptunelabs.fsiframework.concurrent.PriorityExecutor;
import com.neptunelabs.fsiframework.concurrent.PriorityExecutorCompletionService;
import com.neptunelabs.fsiframework.helpers.ExecutorPool;
import com.neptunelabs.fsiframework.helpers.ProcessingException;
import com.neptunelabs.fsiframework.logging.FSILogger;
import com.neptunelabs.imagemanipulator.area.ConvolutionKernel2D;
import com.neptunelabs.imagemanipulator.area.LayerBlend;
import com.neptunelabs.imagemanipulator.color.AlphaMode;
import com.neptunelabs.imagemanipulator.color.BlendMode;
import com.neptunelabs.imagemanipulator.utils.BaseImageUtils;
import com.neptunelabs.imagemanipulator.utils.EffectUtils;
import com.neptunelabs.imagereader.helper.Selection;
import com.neptunelabs.imagereader.image.FSIImage;
import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public final class Convolve2D
extends EffectUtils {
    public static int ZERO_EDGES = 0;
    public static int CLAMP_EDGES = 1;
    public static int WRAP_EDGES = 2;

    public Convolve2D(FSILogger logger, ExecutorPool executorPool, int priority) {
        super(logger, executorPool, priority);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FSIImage transform(FSIImage input, ConvolutionKernel2D kernel, boolean keepInput) throws ProcessingException {
        FSIImage result = null;
        FSIImage targetImage = input.createCompatibleImage();
        boolean error = false;
        int threads = this.executorPool.getAvailableThreads(ExecutorPool.Type.RENDERER_CPU);
        threads = input.getHeight() < threads ? input.getHeight() : threads;
        PriorityExecutorCompletionService completionService = new PriorityExecutorCompletionService(this.executorPool.getExecutorService(ExecutorPool.Type.RENDERER_CPU));
        ArrayList futures = new ArrayList();
        int[][] yRanges = Convolve2D.calcThreadImageRanges(input.getHeight(), threads);
        for (int t = 0; t < threads; ++t) {
            int[] nArray = yRanges[t];
            FilteringThread filterThread = new FilteringThread(nArray[0], nArray[1]);
            filterThread.setImage(input.createSlice());
            filterThread.setTargetImage(targetImage.createSlice());
            filterThread.setKernel(kernel);
            futures.add(completionService.submit(filterThread));
        }
        try {
            for (int c = 0; c < completionService.count(); ++c) {
                completionService.take().get();
            }
        }
        catch (ExecutionException e) {
            error = true;
            return error;
        }
        catch (InterruptedException e) {
            for (Future future : futures) {
                future.cancel(true);
            }
        }
        finally {
            for (Future future : futures) {
                future.cancel(true);
            }
        }
        if (this.alphaSelection != null) {
            FSIImage blended = null;
            try {
                LayerBlend layerBlend = new LayerBlend(this.logger, this.executorPool, this.priority);
                layerBlend.setSelection(new Selection(this.alphaSelection));
                blended = layerBlend.transform(input, targetImage, BlendMode.NORMAL, AlphaMode.NORMAL, true);
            }
            finally {
                targetImage.dispose();
                result = blended;
            }
        } else {
            result = targetImage;
        }
        if (error) {
            Convolve2D.disposeImages(result, targetImage);
        }
        if (!keepInput) {
            input.dispose();
        }
        return result;
    }

    static final int clampFT(float x) {
        if (x < 0.0f) {
            return 0;
        }
        if (x > 1.0f) {
            return 255;
        }
        return (int)(x * 255.0f + 0.5f);
    }

    class FilteringThread
    implements Runnable,
    PriorityExecutor.Important {
        private final int threadStartY;
        private final int threadStopY;
        private FSIImage sourceImage;
        private FSIImage targetImage;
        private int sourceWidth;
        private int sourceHeight;
        private ConvolutionKernel2D kernel;
        private volatile boolean running = false;

        public FilteringThread(int startY, int stopY) {
            this.threadStartY = startY;
            this.threadStopY = stopY;
        }

        @Override
        public int getPriority() {
            return Convolve2D.this.priority;
        }

        public void setImage(FSIImage image) {
            this.sourceImage = image;
            this.sourceWidth = image.getWidth();
            this.sourceHeight = image.getHeight();
        }

        public void setTargetImage(FSIImage image) {
            this.targetImage = image;
        }

        public void setKernel(ConvolutionKernel2D kernel) {
            this.kernel = kernel;
        }

        @Override
        public void run() {
            this.running = true;
            int edgeAction = CLAMP_EDGES;
            int index = this.sourceWidth * this.threadStartY;
            float[] matrix = this.kernel.matrix;
            int rows = this.kernel.height;
            int cols = this.kernel.width;
            int rows2 = rows / 2;
            int cols2 = cols / 2;
            for (int y = this.threadStartY; y <= this.threadStopY && this.running; ++y) {
                for (int x = 0; x < this.sourceWidth && this.running; ++x) {
                    float r = 0.0f;
                    float g = 0.0f;
                    float b = 0.0f;
                    float a = 0.0f;
                    for (int row = -rows2; row <= rows2; ++row) {
                        int ioffset;
                        int iy = y + row;
                        if (0 <= iy && iy < this.sourceHeight) {
                            ioffset = iy * this.sourceWidth;
                        } else if (edgeAction == CLAMP_EDGES) {
                            ioffset = y * this.sourceWidth;
                        } else {
                            if (edgeAction != WRAP_EDGES) continue;
                            ioffset = (iy + this.sourceHeight) % this.sourceHeight * this.sourceWidth;
                        }
                        int moffset = cols * (row + rows2) + cols2;
                        for (int col = -cols2; col <= cols2; ++col) {
                            float f = matrix[moffset + col];
                            if (f == 0.0f) continue;
                            int ix = x + col;
                            if (0 > ix || ix >= this.sourceWidth) {
                                if (edgeAction == CLAMP_EDGES) {
                                    ix = x;
                                } else {
                                    if (edgeAction != WRAP_EDGES) continue;
                                    ix = (x + this.sourceWidth) % this.sourceWidth;
                                }
                            }
                            int rgb = this.sourceImage.getSample(ioffset + ix);
                            a += f * (float)(rgb >> 24 & 0xFF);
                            r += f * (float)(rgb >> 16 & 0xFF);
                            g += f * (float)(rgb >> 8 & 0xFF);
                            b += f * (float)(rgb & 0xFF);
                        }
                    }
                    int ia = BaseImageUtils.clampFT255(a);
                    int ir = BaseImageUtils.clampFT255(r);
                    int ig = BaseImageUtils.clampFT255(g);
                    int ib = BaseImageUtils.clampFT255(b);
                    this.targetImage.setSample(index++, ia << 24 | ir << 16 | ig << 8 | ib);
                }
            }
        }
    }
}

