/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.imagemanipulator.area;

import com.neptunelabs.fsiframework.collections.Pair;
import com.neptunelabs.imagemanipulator.utils.ImageManipulatorException;
import com.neptunelabs.imagereader.image.FSIImage;
import com.neptunelabs.imagereader.image.FSIImageLimited;
import java.nio.BufferOverflowException;
import java.nio.IntBuffer;

public final class Crop {
    private Crop() {
    }

    public static FSIImage transform(FSIImage input, int left, int top, int newWidth, int newHeight, int padColor, CropPadPosition padPosition, float posXOffset, float posYOffset) throws ImageManipulatorException {
        return Crop.transform(input, left, top, newWidth, newHeight, padColor, padPosition, posXOffset, posYOffset, false);
    }

    public static FSIImage transform(FSIImage input, int left, int top, int newWidth, int newHeight, int padColor, CropPadPosition padPosition, float posXOffset, float posYOffset, boolean keepInput) throws ImageManipulatorException {
        if (input == null) {
            throw new ImageManipulatorException("Crop Input Image is null");
        }
        if (newWidth <= 0 || newHeight <= 0) {
            throw new ImageManipulatorException("New image size invalid: " + newWidth + "x" + newHeight);
        }
        if (input instanceof FSIImageLimited) {
            return Crop.transformLimited((FSIImageLimited)input, left, top, newWidth, newHeight, padColor, padPosition, posXOffset, posYOffset, keepInput);
        }
        throw new IllegalArgumentException("Crop is currently only implemented for FSIImageLimited");
    }

    private static FSIImage transformLimited(FSIImageLimited input, int left, int top, int newWidth, int newHeight, int padColor, CropPadPosition padPosition, float posXOffset, float posYOffset, boolean keepInput) throws ImageManipulatorException {
        FSIImageLimited newImage;
        int width = input.getWidth();
        int height = input.getHeight();
        if (newWidth != width || newHeight != height) {
            newImage = input.createCompatibleImage(newWidth, newHeight);
            IntBuffer ibin = input.getSamplesBuffer();
            IntBuffer ibout = newImage.getSamplesBuffer();
            int maxout = ibout.capacity();
            int dxs = 0;
            int dys = 0;
            int xcenter = (newWidth + width) / 2 - width;
            int ycenter = (newHeight + height) / 2 - height;
            if (padPosition != null && (newWidth > width || newHeight > height)) {
                Crop.fillAreaWithPadColor(ibout, padColor, maxout);
                Pair<Integer, Integer> paddoffset = Crop.calcPadOffset(padPosition, posXOffset, posYOffset, xcenter, ycenter, width, height, newWidth, newHeight);
                dxs = paddoffset.getItem1();
                dys = paddoffset.getItem2();
            }
            int right = width > newWidth ? newWidth + left : width;
            int bottom = height > newHeight ? newHeight + top : height;
            int x = 0;
            int y = 0;
            try {
                y = top;
                int dy = dys;
                while (y < bottom) {
                    x = left;
                    int dx = dxs;
                    while (x < right) {
                        int argb = ibin.get(y * width + x);
                        if (dx >= 0 && dx < newWidth && dy >= 0 && dy < newHeight) {
                            newImage.setSample(dx, dy, argb);
                        }
                        ++x;
                        ++dx;
                    }
                    ++y;
                    ++dy;
                }
            }
            catch (BufferOverflowException e) {
                throw new ImageManipulatorException("Crop out of bounds (BO): " + left + "x" + top + ":" + newWidth + "x" + newHeight + " of " + width + "x" + height);
            }
            catch (IndexOutOfBoundsException e) {
                throw new ImageManipulatorException("Crop out of bounds (IO): " + left + "x" + top + ":" + newWidth + "x" + newHeight + " of " + width + "x" + height + " on position " + x + "x" + y + " " + right + ":" + bottom);
            }
        } else {
            newImage = input.createCopy();
        }
        if (!keepInput) {
            input.dispose();
        }
        return newImage;
    }

    private static Pair<Integer, Integer> calcPadOffset(CropPadPosition padPosition, float posXOffset, float posYOffset, int xcenter, int ycenter, int width, int height, int newWidth, int newHeight) {
        int dxs = 0;
        int dys = 0;
        switch (padPosition) {
            case TL: {
                dxs = (int)posXOffset;
                dys = (int)posYOffset;
                break;
            }
            case TC: {
                dxs = (int)((float)xcenter + posXOffset);
                dys = (int)posYOffset;
                break;
            }
            case TR: {
                dxs = (int)((float)(newWidth - width) + posXOffset);
                dys = (int)posYOffset;
                break;
            }
            case CL: {
                dxs = (int)posXOffset;
                dys = (int)((float)ycenter + posYOffset);
                break;
            }
            case CR: {
                dxs = (int)((float)(newWidth - width) + posXOffset);
                dys = (int)((float)ycenter + posYOffset);
                break;
            }
            case BL: {
                dxs = (int)posXOffset;
                dys = (int)((float)(newHeight - height) + posYOffset);
                break;
            }
            case BC: {
                dxs = (int)((float)xcenter + posXOffset);
                dys = (int)((float)(newHeight - height) + posYOffset);
                break;
            }
            case BR: {
                dxs = (int)((float)(newWidth - width) + posXOffset);
                dys = (int)((float)(newHeight - height) + posYOffset);
                break;
            }
            case RELATIVE: {
                dxs = (int)((float)newWidth * posXOffset / 100.0f);
                dys = (int)((float)newHeight * posYOffset / 100.0f);
                break;
            }
            default: {
                dxs = (int)((float)xcenter + posXOffset);
                dys = (int)((float)ycenter + posYOffset);
            }
        }
        return new Pair<Integer, Integer>(dxs, dys);
    }

    private static void fillAreaWithPadColor(IntBuffer ibout, int padColor, int maxout) {
        for (int s = 0; s < maxout; ++s) {
            ibout.put(padColor);
        }
        ibout.position(0);
    }

    public static enum CropPadPosition {
        TL,
        TC,
        TR,
        CL,
        CC,
        CR,
        BL,
        BC,
        BR,
        RELATIVE;

    }
}

