/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.imagemanipulator.area;

import com.neptunelabs.fsiframework.concurrent.PriorityExecutor;
import com.neptunelabs.fsiframework.concurrent.PriorityExecutorCompletionService;
import com.neptunelabs.fsiframework.helpers.ExecutorPool;
import com.neptunelabs.fsiframework.helpers.ProcessingException;
import com.neptunelabs.fsiframework.logging.FSILogger;
import com.neptunelabs.imagemanipulator.utils.EffectUtils;
import com.neptunelabs.imagereader.image.FSIImage;
import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public class Emboss
extends EffectUtils {
    public Emboss(FSILogger logger, ExecutorPool executorPool, int priority) {
        super(logger, executorPool, priority);
    }

    /*
     * Could not resolve type clashes
     * Loose catch block
     */
    public FSIImage transform(FSIImage sourceImage, boolean keepInput) throws ProcessingException {
        FSIImage targetImage = sourceImage.createCompatibleImage();
        int threads = this.calcThreads(sourceImage);
        PriorityExecutorCompletionService completionService = new PriorityExecutorCompletionService(this.executorPool.getExecutorService(ExecutorPool.Type.RENDERER_CPU), threads);
        ArrayList futures = new ArrayList(threads);
        int[][] yRanges = Emboss.calcThreadImageRanges(sourceImage.getHeight(), threads);
        boolean error = false;
        for (int t = 0; t < threads; ++t) {
            int[] yRange = yRanges[t];
            EmbossThread filterThread = new EmbossThread(sourceImage, targetImage, yRange[0], yRange[1]);
            futures.add(completionService.submit(filterThread));
        }
        try {
            for (int c = 0; c < completionService.count(); ++c) {
                completionService.take().get();
            }
        }
        catch (InterruptedException c) {
            for (Future f : futures) {
                f.cancel(true);
            }
            if (error) {
                Emboss.disposeImages(targetImage);
            }
        }
        catch (ExecutionException e) {
            error = true;
            throw new ProcessingException(e.getCause());
            {
                catch (Throwable throwable) {
                    for (Future f : futures) {
                        f.cancel(true);
                    }
                    if (error) {
                        Emboss.disposeImages(targetImage);
                    }
                    throw throwable;
                }
            }
        }
        for (Future f : futures) {
            f.cancel(true);
        }
        if (error) {
            Emboss.disposeImages(targetImage);
        }
        if (!keepInput) {
            sourceImage.dispose();
        }
        return targetImage;
    }

    private final class EmbossThread
    implements Runnable,
    PriorityExecutor.Important {
        private final FSIImage src;
        private final FSIImage dst;
        private final int threadStartY;
        private final int threadStopY;

        EmbossThread(FSIImage src, FSIImage dst, int startY, int stopY) {
            this.src = src;
            this.dst = dst;
            this.threadStartY = startY;
            this.threadStopY = stopY;
        }

        @Override
        public int getPriority() {
            return Emboss.this.priority;
        }

        @Override
        public void run() {
            int width = this.src.getWidth();
            for (int i = this.threadStartY; i <= this.threadStopY; ++i) {
                for (int j = 0; j < width; ++j) {
                    int current = this.src.getSample(j, i);
                    int upperLeft = 0;
                    if (i > 0 && j > 0) {
                        upperLeft = this.src.getSample(j - 1, i - 1);
                    }
                    int rDiff = (current >> 16 & 0xFF) - (upperLeft >> 16 & 0xFF);
                    int gDiff = (current >> 8 & 0xFF) - (upperLeft >> 8 & 0xFF);
                    int bDiff = (current & 0xFF) - (upperLeft & 0xFF);
                    int diff = rDiff;
                    if (Math.abs(gDiff) > Math.abs(diff)) {
                        diff = gDiff;
                    }
                    if (Math.abs(bDiff) > Math.abs(diff)) {
                        diff = bDiff;
                    }
                    int grayLevel = Math.max(Math.min(128 + diff, 255), 0);
                    this.dst.setSample(j, i, (grayLevel << 16) + (grayLevel << 8) + grayLevel);
                }
            }
        }
    }
}

