/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.imagemanipulator.area;

import com.neptunelabs.imagereader.image.FSIImage;

public final class FSIServerWatermark {
    private static final float opacity = 0.5f;
    private static final int r0 = 238;
    private static final int g0 = 112;
    private static final int b0 = 74;

    public static FSIImage transform(FSIImage input, byte[] watermark) {
        if (input.getWidth() > 250 && input.getHeight() > 250) {
            int nargb;
            float opa1;
            int b2;
            int g2;
            int r2;
            int b1;
            int g1;
            int r1;
            int a1;
            int argb;
            int wwidth = (watermark[0] & 0xFF) + 4;
            int wheight = (watermark[1] & 0xFF) + 4;
            int left = input.getWidth() / 2 - wwidth / 2;
            int top = input.getHeight() / 2 - wheight / 2;
            int bottom = top + wheight;
            int right = left + wwidth;
            for (int y = top; y < bottom; ++y) {
                float opa;
                int x;
                for (x = left; x < right; ++x) {
                    argb = input.getSample(x, y);
                    a1 = argb >>> 24 & 0xFF;
                    r1 = argb >> 16 & 0xFF;
                    g1 = argb >> 8 & 0xFF;
                    b1 = argb & 0xFF;
                    r2 = 255 - ((255 - r1) * 17 >> 8);
                    g2 = 255 - ((255 - g1) * 143 >> 8);
                    b2 = 255 - ((255 - b1) * 181 >> 8);
                    opa = 0.5f;
                    opa1 = 1.0f - opa;
                    r2 = (int)(opa * (float)r2 + opa1 * (float)r1);
                    g2 = (int)(opa * (float)g2 + opa1 * (float)g1);
                    b2 = (int)(opa * (float)b2 + opa1 * (float)b1);
                    nargb = a1 << 24 | r2 << 16 | g2 << 8 | b2;
                    input.setSample(x, y, nargb);
                }
                int o = 0;
                x = left - 32;
                while (x < left) {
                    argb = input.getSample(x, y);
                    a1 = argb >>> 24 & 0xFF;
                    r1 = argb >> 16 & 0xFF;
                    g1 = argb >> 8 & 0xFF;
                    b1 = argb & 0xFF;
                    r2 = 255 - ((255 - r1) * 17 >> 8);
                    g2 = 255 - ((255 - g1) * 143 >> 8);
                    b2 = 255 - ((255 - b1) * 181 >> 8);
                    opa = (float)o / 255.0f * 0.5f;
                    opa1 = 1.0f - opa;
                    r2 = (int)(opa * (float)r2 + opa1 * (float)r1);
                    g2 = (int)(opa * (float)g2 + opa1 * (float)g1);
                    b2 = (int)(opa * (float)b2 + opa1 * (float)b1);
                    nargb = a1 << 24 | r2 << 16 | g2 << 8 | b2;
                    input.setSample(x, y, nargb);
                    ++x;
                    o += 8;
                }
                o = 255;
                x = right;
                while (x < right + 32) {
                    argb = input.getSample(x, y);
                    a1 = argb >>> 24 & 0xFF;
                    r1 = argb >> 16 & 0xFF;
                    g1 = argb >> 8 & 0xFF;
                    b1 = argb & 0xFF;
                    r2 = 255 - ((255 - r1) * 17 >> 8);
                    g2 = 255 - ((255 - g1) * 143 >> 8);
                    b2 = 255 - ((255 - b1) * 181 >> 8);
                    opa = (float)o / 255.0f * 0.5f;
                    opa1 = 1.0f - opa;
                    r2 = (int)(opa * (float)r2 + opa1 * (float)r1);
                    g2 = (int)(opa * (float)g2 + opa1 * (float)g1);
                    b2 = (int)(opa * (float)b2 + opa1 * (float)b1);
                    nargb = a1 << 24 | r2 << 16 | g2 << 8 | b2;
                    input.setSample(x, y, nargb);
                    ++x;
                    o -= 8;
                }
            }
            int bitpos = 7;
            int bytepos = 2;
            for (int y = top + 2; y < bottom - 2; ++y) {
                for (int x = left + 2; x < right - 2; ++x) {
                    int bit;
                    byte b = watermark[bytepos];
                    if ((bit = b >> bitpos-- & 1) == 1) {
                        argb = input.getSample(x, y);
                        a1 = argb >>> 24 & 0xFF;
                        r1 = argb >> 16 & 0xFF;
                        g1 = argb >> 8 & 0xFF;
                        b1 = argb & 0xFF;
                        opa1 = 0.5f;
                        r2 = (int)(opa1 * (float)r1);
                        g2 = (int)(opa1 * (float)g1);
                        b2 = (int)(opa1 * (float)b1);
                        nargb = a1 << 24 | r2 << 16 | g2 << 8 | b2;
                        input.setSample(x, y, nargb);
                    }
                    if (bitpos != -1) continue;
                    bitpos = 7;
                    ++bytepos;
                }
            }
        }
        return input;
    }
}

