/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.imagemanipulator.area;

import com.neptunelabs.fsiframework.helpers.ExecutorPool;
import com.neptunelabs.fsiframework.logging.FSILogger;
import com.neptunelabs.imagemanipulator.utils.EffectUtils;
import com.neptunelabs.imagereader.image.FSIImage;

public final class Flip
extends EffectUtils {
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;

    public Flip(FSILogger logger, ExecutorPool executorPool, int priority) {
        super(logger, executorPool, priority);
    }

    public FSIImage transform(FSIImage input, int direction, boolean keepInput) {
        FSIImage result;
        if (direction == 0) {
            result = this.horizontal(input);
        } else if (direction == 1) {
            result = this.vertical(input);
        } else {
            throw new IllegalArgumentException("direction must be HORIZONTAL or VERTICAL");
        }
        if (!keepInput) {
            input.dispose();
        }
        return result;
    }

    private FSIImage horizontal(FSIImage input) {
        int width = input.getWidth();
        int height = input.getHeight();
        FSIImage result = input.createCompatibleImage(width, height);
        for (int y = 0; y < height; ++y) {
            input.setPosition(y * width);
            for (int x = width - 1; x >= 0; --x) {
                result.setSample(x, y, input.getSample());
            }
        }
        if (input.getExtraAlphaCount() > 0) {
            result.createExtraAlpha(input.getExtraAlphaCount());
            for (int b = 0; b < input.getExtraAlphaCount(); ++b) {
                for (int y = 0; y < height; ++y) {
                    input.setPositionExtraAlpha(b, y * width);
                    for (int x = width - 1; x >= 0; --x) {
                        result.setSampleExtraAlpha(b, x, y, input.getSampleExtraAlpha(b));
                    }
                }
            }
        }
        return result;
    }

    private FSIImage vertical(FSIImage input) {
        int width = input.getWidth();
        int height = input.getHeight();
        FSIImage result = input.createCompatibleImage(width, height);
        for (int y = 0; y < height; ++y) {
            input.setPosition(y * width);
            result.setPosition((height - y - 1) * width);
            for (int x = 0; x < width; ++x) {
                result.setSample(input.getSample());
            }
        }
        if (input.getExtraAlphaCount() > 0) {
            result.createExtraAlpha(input.getExtraAlphaCount());
            for (int b = 0; b < input.getExtraAlphaCount(); ++b) {
                for (int y = 0; y < height; ++y) {
                    input.setPositionExtraAlpha(b, y * width);
                    result.setPositionExtraAlpha(b, (height - y - 1) * width);
                    for (int x = width - 1; x >= 0; --x) {
                        result.setSampleExtraAlpha(b, input.getSampleExtraAlpha(b));
                    }
                }
            }
        }
        return result;
    }
}

