/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.imagemanipulator.area;

import com.neptunelabs.fsiframework.helpers.ExecutorPool;
import com.neptunelabs.fsiframework.helpers.ProcessingException;
import com.neptunelabs.fsiframework.logging.FSILogger;
import com.neptunelabs.imagemanipulator.area.ConvolutionKernel1D;
import com.neptunelabs.imagemanipulator.area.Convolve1D;
import com.neptunelabs.imagemanipulator.area.LayerBlend;
import com.neptunelabs.imagemanipulator.color.AlphaMode;
import com.neptunelabs.imagemanipulator.color.BlendMode;
import com.neptunelabs.imagemanipulator.utils.BaseImageUtils;
import com.neptunelabs.imagemanipulator.utils.EffectUtils;
import com.neptunelabs.imagereader.helper.Selection;
import com.neptunelabs.imagereader.image.FSIImage;

public final class Gaussian
extends EffectUtils {
    public Gaussian(FSILogger logger, ExecutorPool executorPool, int priority) {
        super(logger, executorPool, priority);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FSIImage transform(FSIImage input, int radius, float unsharpenAmount, int unsharpenThreshold, float bloomAmount, boolean keepInput) throws ProcessingException {
        FSIImage result = null;
        if (radius > 0 || unsharpenAmount > 0.0f || bloomAmount > 0.0f) {
            block12: {
                try {
                    double sigma = (float)radius / 3.0f;
                    ConvolutionKernel1D ckernel = ConvolutionKernel1D.getGaussianKernel(radius, sigma);
                    Convolve1D convolve1D = new Convolve1D(this.logger, this.executorPool, this.priority);
                    result = convolve1D.transform(input, ckernel, true);
                    if (unsharpenAmount > 0.0f) {
                        Gaussian.unSharpen(input, result, unsharpenAmount / 100.0f, unsharpenThreshold);
                    }
                    if (bloomAmount > 0.0f) {
                        Gaussian.blooming(input, result, bloomAmount / 100.0f);
                    }
                    if (this.alphaSelection == null) break block12;
                    FSIImage blended = null;
                    try {
                        LayerBlend blend = new LayerBlend(this.logger, this.executorPool, this.priority);
                        blend.setSelection(new Selection(this.alphaSelection));
                        blended = blend.transform(input, result, BlendMode.NORMAL, AlphaMode.NORMAL, true);
                    }
                    finally {
                        result.dispose();
                        result = blended;
                    }
                }
                catch (ProcessingException e) {
                    Gaussian.disposeImages(result);
                    throw e;
                }
            }
            if (!keepInput) {
                input.dispose();
            }
        } else if (!keepInput) {
            result = input.createCopy();
            input.dispose();
        } else {
            result = input;
        }
        return result;
    }

    private static void unSharpen(FSIImage orgImage, FSIImage blurImage, float amount, int threshold) {
        int width = orgImage.getWidth();
        int height = orgImage.getHeight();
        amount += 1.0f;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int rgb1 = orgImage.getSample(x, y);
                int a1 = rgb1 >>> 24 & 0xFF;
                int r1 = rgb1 >> 16 & 0xFF;
                int g1 = rgb1 >> 8 & 0xFF;
                int b1 = rgb1 & 0xFF;
                int rgb2 = blurImage.getSample(x, y);
                int a2 = rgb2 >>> 24 & 0xFF;
                int r2 = rgb2 >> 16 & 0xFF;
                int g2 = rgb2 >> 8 & 0xFF;
                int b2 = rgb2 & 0xFF;
                if (Math.abs(a1 - a2) >= threshold) {
                    a1 = BaseImageUtils.clampFT255((int)(amount * (float)(a1 - a2) + (float)a2));
                }
                if (Math.abs(r1 - r2) >= threshold) {
                    r1 = BaseImageUtils.clampFT255((int)(amount * (float)(r1 - r2) + (float)r2));
                }
                if (Math.abs(g1 - g2) >= threshold) {
                    g1 = BaseImageUtils.clampFT255((int)(amount * (float)(g1 - g2) + (float)g2));
                }
                if (Math.abs(b1 - b2) >= threshold) {
                    b1 = BaseImageUtils.clampFT255((int)(amount * (float)(b1 - b2) + (float)b2));
                }
                blurImage.setSample(x, y, a1 << 24 | r1 << 16 | g1 << 8 | b1);
            }
        }
    }

    private static void blooming(FSIImage orgImage, FSIImage blurImage, float amount) {
        int width = orgImage.getWidth();
        int height = orgImage.getHeight();
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int rgb1 = orgImage.getSample(x, y);
                int a1 = rgb1 >>> 24 & 0xFF;
                int r1 = rgb1 >> 16 & 0xFF;
                int g1 = rgb1 >> 8 & 0xFF;
                int b1 = rgb1 & 0xFF;
                int rgb2 = blurImage.getSample(x, y);
                int a2 = rgb2 >>> 24 & 0xFF;
                int r2 = rgb2 >> 16 & 0xFF;
                int g2 = rgb2 >> 8 & 0xFF;
                int b2 = rgb2 & 0xFF;
                a1 = BaseImageUtils.clampFT255((int)((float)a1 + amount * (float)a2));
                r1 = BaseImageUtils.clampFT255((int)((float)r1 + amount * (float)r2));
                g1 = BaseImageUtils.clampFT255((int)((float)g1 + amount * (float)g2));
                b1 = BaseImageUtils.clampFT255((int)((float)b1 + amount * (float)b2));
                blurImage.setSample(x, y, a1 << 24 | r1 << 16 | g1 << 8 | b1);
            }
        }
    }
}

