/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.imagemanipulator.area;

import com.neptunelabs.fsiframework.concurrent.PriorityExecutorCompletionService;
import com.neptunelabs.fsiframework.helpers.ExecutorPool;
import com.neptunelabs.fsiframework.helpers.ProcessingException;
import com.neptunelabs.fsiframework.logging.FSILogger;
import com.neptunelabs.imagemanipulator.color.AlphaMode;
import com.neptunelabs.imagemanipulator.color.BlendMode;
import com.neptunelabs.imagemanipulator.color.ColorOverlay2;
import com.neptunelabs.imagemanipulator.utils.EffectThreadAbstract;
import com.neptunelabs.imagemanipulator.utils.EffectUtils;
import com.neptunelabs.imagereader.image.FSIImage;
import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public final class LayerBlend
extends EffectUtils {
    public LayerBlend(FSILogger logger, ExecutorPool executorPool, int priority) {
        super(logger, executorPool, priority);
    }

    public FSIImage transform(FSIImage base, FSIImage layer, int x, int y, BlendMode mode, float opacity, boolean keepInput) {
        return this.transform(base, layer, x, y, mode, AlphaMode.NORMAL, opacity, keepInput);
    }

    public FSIImage transform(FSIImage input, FSIImage layer, int x, int y, BlendMode mode, AlphaMode alphaMode, float opacity, boolean keepInput) {
        FSIImage result = input.createCopy();
        boolean success = this.blend(input, result, layer, x, y, mode, alphaMode, opacity);
        if (!success) {
            LayerBlend.disposeImages(result);
        }
        if (!keepInput) {
            LayerBlend.disposeImages(input, layer);
        }
        return result;
    }

    public FSIImage transform(FSIImage input, FSIImage layer, BlendMode mode, AlphaMode alphaMode, boolean keepInput) throws ProcessingException {
        FSIImage result = input.createCompatibleImage();
        boolean success = this.blend(input, result, layer, mode, alphaMode);
        if (!success) {
            LayerBlend.disposeImages(result);
        }
        if (!keepInput) {
            LayerBlend.disposeImages(input, layer);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean blend(FSIImage input, FSIImage result, FSIImage layer, BlendMode mode, AlphaMode alphaMode) {
        ColorOverlay2 blendEffect = new ColorOverlay2(mode, alphaMode);
        int threads = this.calcThreads(layer);
        PriorityExecutorCompletionService completionService = new PriorityExecutorCompletionService(this.executorPool.getExecutorService(ExecutorPool.Type.RENDERER_CPU), threads);
        ArrayList futures = new ArrayList(threads);
        int[][] yRanges = LayerBlend.calcThreadImageRanges(layer.getHeight(), threads);
        for (int t = 0; t < threads; ++t) {
            int[] yRange = yRanges[t];
            SelectionBlendThread selectionBlendThread = new SelectionBlendThread(this.priority, yRange[0], yRange[1]);
            selectionBlendThread.setOptions(layer, 0, 0, blendEffect);
            selectionBlendThread.setAlphaSelection(this.alphaSelection);
            selectionBlendThread.setImages(input, result);
            futures.add(completionService.submit(selectionBlendThread));
        }
        boolean error = false;
        try {
            for (int c = 0; c < completionService.count(); ++c) {
                completionService.take().get();
            }
        }
        catch (ExecutionException e) {
            error = true;
            return error;
        }
        catch (InterruptedException interruptedException) {
            for (Future future : futures) {
                future.cancel(true);
            }
        }
        finally {
            for (Future future : futures) {
                future.cancel(true);
            }
        }
        return !error;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean blend(FSIImage input, FSIImage result, FSIImage layer, int x, int y, BlendMode mode, AlphaMode alphaMode, float opacity) {
        ColorOverlay2 blendEffect = new ColorOverlay2(mode, alphaMode, opacity);
        int threads = this.calcThreads(layer);
        PriorityExecutorCompletionService completionService = new PriorityExecutorCompletionService(this.executorPool.getExecutorService(ExecutorPool.Type.RENDERER_CPU), threads);
        ArrayList futures = new ArrayList(threads);
        int blendHeight = layer.getHeight();
        if (result.getHeight() - y < blendHeight) {
            blendHeight = result.getHeight() - y;
        }
        int[][] yRanges = LayerBlend.calcThreadImageRanges(blendHeight, threads);
        for (int t = 0; t < threads; ++t) {
            int[] yRange = yRanges[t];
            BlendThread blendThread = new BlendThread(this.priority, yRange[0], yRange[1]);
            blendThread.setOptions(layer, x, y, blendEffect);
            blendThread.setImages(input, result);
            futures.add(completionService.submit(blendThread));
        }
        boolean error = false;
        try {
            for (int c = 0; c < completionService.count(); ++c) {
                completionService.take().get();
            }
        }
        catch (ExecutionException e) {
            error = true;
            return error;
        }
        catch (InterruptedException interruptedException) {
            for (Future future : futures) {
                future.cancel(true);
            }
        }
        finally {
            for (Future future : futures) {
                future.cancel(true);
            }
        }
        return !error;
    }

    private final class BlendThread
    extends EffectThreadAbstract {
        private FSIImage layer;
        private int offsetX;
        private int offsetY;
        private ColorOverlay2 blendEffect;

        public BlendThread(int priority, int fromY, int toY) {
            super(priority, fromY, toY);
        }

        public void setOptions(FSIImage layer, int offsetX, int offsetY, ColorOverlay2 blendEffect) {
            this.layer = layer;
            this.offsetX = offsetX;
            this.offsetY = offsetY;
            this.blendEffect = blendEffect;
        }

        @Override
        public void run() {
            int layerWidth = this.layer.getWidth();
            int bgWidth = this.baseImage.getWidth();
            int bgHeight = this.baseImage.getHeight();
            int p = this.fromY * layerWidth;
            for (int y = this.fromY; y <= this.toY; ++y) {
                int backgroundY = y + this.offsetY;
                int x = 0;
                while (x < layerWidth) {
                    int backgroundX = x + this.offsetX;
                    if (backgroundX < bgWidth && backgroundY < bgHeight && backgroundX >= 0 && backgroundY >= 0) {
                        int value = this.blendEffect.transform(this.baseImage.getSample(backgroundX, backgroundY), this.layer.getSample(x, y), p);
                        this.newImage.setSample(backgroundX, backgroundY, value);
                    }
                    ++x;
                    ++p;
                }
            }
        }
    }

    private final class SelectionBlendThread
    extends EffectThreadAbstract {
        private FSIImage layer;
        private int offsetX;
        private int offsetY;
        private ColorOverlay2 blendEffect;

        public SelectionBlendThread(int priority, int fromY, int toY) {
            super(priority, fromY, toY);
        }

        public void setOptions(FSIImage layer, int offsetX, int offsetY, ColorOverlay2 blendEffect) {
            this.layer = layer;
            this.offsetX = offsetX;
            this.offsetY = offsetY;
            this.blendEffect = blendEffect;
        }

        @Override
        public void run() {
            int layerWidth = this.layer.getWidth();
            int bgWidth = this.baseImage.getWidth();
            int bgHeight = this.baseImage.getHeight();
            int p = this.fromY * layerWidth;
            for (int y = this.fromY; y <= this.toY; ++y) {
                int backgroundY = y + this.offsetY;
                int x = 0;
                while (x < layerWidth) {
                    int backgroundX = x + this.offsetX;
                    if (backgroundX < bgWidth && backgroundY < bgHeight && backgroundX >= 0 && backgroundY >= 0) {
                        int alphaPos = y * layerWidth + x;
                        float alpha = (float)(LayerBlend.this.alphaSelection[alphaPos] & 0xFF) / 255.0f;
                        int value = this.blendEffect.transform(this.baseImage.getSample(backgroundX, backgroundY), this.layer.getSample(x, y), p, alpha);
                        this.newImage.setSample(backgroundX, backgroundY, value);
                    }
                    ++x;
                    ++p;
                }
            }
        }
    }
}

