/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.imagemanipulator.area;

import com.neptunelabs.fsiframework.concurrent.PriorityExecutor;
import com.neptunelabs.fsiframework.concurrent.PriorityExecutorCompletionService;
import com.neptunelabs.fsiframework.helpers.ExecutorPool;
import com.neptunelabs.fsiframework.helpers.ProcessingException;
import com.neptunelabs.fsiframework.logging.FSILogger;
import com.neptunelabs.imagemanipulator.color.AlphaMode;
import com.neptunelabs.imagemanipulator.color.BlendMode;
import com.neptunelabs.imagemanipulator.color.ColorOverlay2;
import com.neptunelabs.imagemanipulator.helper.SmoothGradient;
import com.neptunelabs.imagemanipulator.utils.EffectUtils;
import com.neptunelabs.imagereader.converter.FastMath;
import com.neptunelabs.imagereader.image.FSIImage;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public class LinearGradient
extends EffectUtils {
    public LinearGradient(FSILogger logger, ExecutorPool executorPool, int priority) {
        super(logger, executorPool, priority);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FSIImage transform(FSIImage input, SmoothGradient gradient, Point2D.Float start, Point2D.Float stop, BlendMode blendmode, AlphaMode alphamode, float opacity, boolean keepInput) throws ProcessingException {
        FSIImage newImage = input.createCompatibleImage();
        int startX = FastMath.round(start.x * (float)input.getWidth());
        int startY = FastMath.round(start.y * (float)input.getHeight());
        int stopX = FastMath.round(stop.x * (float)input.getWidth());
        int stopY = FastMath.round(stop.y * (float)input.getHeight());
        float dist = this.dist(startX, startY, stopX, stopY);
        float dx = (float)(stopX - startX) / dist;
        float dy = (float)(stopY - startX) / dist;
        int offx = startX;
        int offy = startY;
        System.err.println("IMG:" + input.getWidth() + "x" + input.getHeight());
        System.err.println("OFF:" + startX + "x" + startY);
        System.err.println("SS:" + startX + "x" + startY + " SO:" + stopX + "x" + stopY + " Dist:" + dist + " DX:DY:" + dx + "x" + dy);
        int threads = this.calcThreads(input);
        PriorityExecutorCompletionService completionService = new PriorityExecutorCompletionService(this.executorPool.getExecutorService(ExecutorPool.Type.RENDERER_CPU));
        ArrayList futures = new ArrayList();
        ColorOverlay2 blender = new ColorOverlay2(blendmode, alphamode, opacity);
        for (int t = 0; t < threads; ++t) {
            LinearGradientThread et = new LinearGradientThread(input, newImage, threads, t, dist, dx, dy, offx, offy, gradient, blender);
            futures.add(completionService.submit(et));
        }
        boolean error = false;
        try {
            for (int c = 0; c < completionService.count(); ++c) {
                completionService.take().get();
            }
        }
        catch (ExecutionException e) {
            error = true;
            throw new ProcessingException(e);
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            for (Future future : futures) {
                future.cancel(true);
            }
            if (error) {
                newImage.dispose();
            }
        }
        if (!keepInput) {
            input.dispose();
        }
        return newImage;
    }

    private float dist(float x1, float y1, float x2, float y2) {
        return (float)Math.sqrt((x1 - x2) * (x1 - x2) + (y1 - y2) * (y1 - y2));
    }

    private final class LinearGradientThread
    implements Runnable,
    PriorityExecutor.Important {
        private final FSIImage src;
        private final FSIImage dst;
        private final int threads;
        private final int threadnum;
        private final float dist;
        private final float dx;
        private final float dy;
        private final int offX;
        private final int offY;
        private final SmoothGradient gradient;
        private final ColorOverlay2 blender;

        LinearGradientThread(FSIImage src, FSIImage dst, int threads, int threadnum, float dist, float dx, float dy, int xoff, int yoff, SmoothGradient gradient, ColorOverlay2 blender) {
            this.src = src;
            this.dst = dst;
            this.threads = threads;
            this.threadnum = threadnum;
            this.dist = dist;
            this.dx = dx;
            this.dy = dy;
            this.offX = xoff;
            this.offY = yoff;
            this.gradient = gradient;
            this.blender = blender;
        }

        @Override
        public int getPriority() {
            return LinearGradient.this.priority;
        }

        @Override
        public void run() {
            int width = this.src.getWidth();
            int height = this.src.getHeight();
            int p = this.threadnum;
            for (int y = this.threadnum; y < height; y += this.threads) {
                int x = 0;
                while (x < width) {
                    float v = this.dist == 0.0f ? 0.0f : (this.dx * (float)(x + this.offX) + this.dy * (float)(y + this.offY)) / this.dist;
                    this.dst.setSample(x, y, this.blender.transform(this.src.getSample(x, y), this.gradient.getValue(v), p));
                    ++x;
                    ++p;
                }
            }
        }
    }
}

