/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.imagemanipulator.area;

import com.neptunelabs.fsiframework.concurrent.PriorityExecutorCompletionService;
import com.neptunelabs.fsiframework.helpers.ExecutorPool;
import com.neptunelabs.fsiframework.helpers.ProcessingException;
import com.neptunelabs.fsiframework.logging.FSILogger;
import com.neptunelabs.imagemanipulator.utils.EffectThreadAbstract;
import com.neptunelabs.imagemanipulator.utils.EffectUtils;
import com.neptunelabs.imagereader.image.FSIImage;
import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public final class Pixelize
extends EffectUtils {
    public Pixelize(FSILogger logger, ExecutorPool executorPool, int priority) {
        super(logger, executorPool, priority);
    }

    /*
     * Could not resolve type clashes
     * Loose catch block
     */
    public FSIImage transform(FSIImage input, int pixelSizeIn, boolean keepInput) throws ProcessingException {
        int pixelSize = pixelSizeIn <= 0 ? 1 : pixelSizeIn;
        FSIImage newImage = input.createCopy();
        int threads = this.calcThreads(newImage);
        PriorityExecutorCompletionService completionService = new PriorityExecutorCompletionService(this.executorPool.getExecutorService(ExecutorPool.Type.RENDERER_CPU));
        ArrayList futures = new ArrayList();
        int[][] yRanges = Pixelize.calcThreadImageRanges(input.getHeight(), threads);
        for (int t = 0; t < threads; ++t) {
            int[] yRange = yRanges[t];
            FilteringThreadPixelize filterThread = new FilteringThreadPixelize(this.priority, yRange[0], yRange[1]);
            filterThread.setOptions(pixelSize);
            filterThread.setAlphaSelection(this.alphaSelection);
            filterThread.setImages(input, newImage);
            futures.add(completionService.submit(filterThread));
        }
        boolean error = false;
        try {
            for (int c = 0; c < completionService.count(); ++c) {
                completionService.take().get();
            }
        }
        catch (InterruptedException c) {
            for (Future f : futures) {
                f.cancel(true);
            }
            if (error) {
                Pixelize.disposeImages(newImage);
            }
        }
        catch (ExecutionException e) {
            error = true;
            throw new ProcessingException(e);
            {
                catch (Throwable throwable) {
                    for (Future f : futures) {
                        f.cancel(true);
                    }
                    if (error) {
                        Pixelize.disposeImages(newImage);
                    }
                    throw throwable;
                }
            }
        }
        for (Future f : futures) {
            f.cancel(true);
        }
        if (error) {
            Pixelize.disposeImages(newImage);
        }
        if (!keepInput) {
            input.dispose();
        }
        return newImage;
    }

    private final class FilteringThreadPixelize
    extends EffectThreadAbstract {
        private int pixelSize;

        FilteringThreadPixelize(int priority, int fromY, int toY) {
            super(priority, fromY, toY);
        }

        public void setOptions(int pixelSize) {
            this.pixelSize = pixelSize;
        }

        @Override
        public void run() {
            if (Pixelize.this.alphaSelection == null) {
                this.processRange();
            } else {
                this.processSelection();
            }
        }

        private void processRange() {
            int width = this.baseImage.getWidth();
            for (int y = this.fromY; y <= this.toY; ++y) {
                int oy = y / this.pixelSize * this.pixelSize;
                for (int x = 0; x < width; ++x) {
                    int ox = x / this.pixelSize * this.pixelSize;
                    int argb = this.baseImage.getSample(ox, oy);
                    this.newImage.setSample(x, y, argb);
                }
            }
        }

        private void processSelection() {
            int argb = 0;
            int asPos = this.baseWidth * this.fromY;
            for (int y = this.fromY; y <= this.toY; ++y) {
                int oy = y / this.pixelSize * this.pixelSize;
                int x = 0;
                while (x < this.baseWidth) {
                    int sel = Pixelize.this.alphaSelection[asPos] & 0xFF;
                    if (sel > 0) {
                        int ox = x / this.pixelSize * this.pixelSize;
                        argb = this.baseImage.getSample(ox, oy);
                        int baseARGB = this.baseImage.getSample(x, y);
                        argb = FilteringThreadPixelize.blend(baseARGB, argb, sel);
                        this.newImage.setSample(x, y, argb);
                    }
                    ++x;
                    ++asPos;
                }
            }
        }
    }
}

