/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.imagemanipulator.area;

import com.neptunelabs.fsiframework.helpers.ExecutorPool;
import com.neptunelabs.fsiframework.logging.FSILogger;
import com.neptunelabs.imagemanipulator.area.Flip;
import com.neptunelabs.imagemanipulator.utils.EffectUtils;
import com.neptunelabs.imagereader.image.FSIImage;

public final class Rotate90
extends EffectUtils {
    public Rotate90(FSILogger logger, ExecutorPool executorPool, int priority) {
        super(logger, executorPool, priority);
    }

    public FSIImage transform(FSIImage input, int rotation, boolean keepInput) {
        FSIImage result;
        if (rotation % 90 != 0) {
            throw new IllegalArgumentException("rotation angle must be a multiple of 90");
        }
        if (rotation % 270 == 0) {
            result = this.introtate(input, false);
        } else if (rotation % 180 == 0) {
            Flip flip = new Flip(this.logger, this.executorPool, this.priority);
            result = flip.transform(input, 0, true);
            result = flip.transform(result, 1, false);
        } else {
            result = this.introtate(input, true);
        }
        if (!keepInput) {
            input.dispose();
        }
        return result;
    }

    private FSIImage introtate(FSIImage input, boolean dir) {
        FSIImage result;
        block13: {
            int height;
            int width;
            block12: {
                width = input.getWidth();
                height = input.getHeight();
                result = input.createCompatibleImage(height, width);
                if (input.getExtraAlphaCount() > 0) {
                    result.createExtraAlpha(input.getExtraAlphaCount());
                }
                if (!dir) break block12;
                for (int x = 0; x < width; ++x) {
                    for (int y = 0; y < height; ++y) {
                        result.setSample(-y + height - 1, x, input.getSample(x, y));
                    }
                }
                if (input.getExtraAlphaCount() <= 0) break block13;
                for (int b = 0; b < input.getExtraAlphaCount(); ++b) {
                    for (int x = 0; x < width; ++x) {
                        for (int y = 0; y < height; ++y) {
                            result.setSampleExtraAlpha(b, -y + height - 1, x, input.getSampleExtraAlpha(b, x, y));
                        }
                    }
                }
                break block13;
            }
            for (int x = 0; x < width; ++x) {
                for (int y = 0; y < height; ++y) {
                    result.setSample(y, -x + width - 1, input.getSample(x, y));
                }
            }
            if (input.getExtraAlphaCount() > 0) {
                for (int b = 0; b < input.getExtraAlphaCount(); ++b) {
                    for (int x = 0; x < width; ++x) {
                        for (int y = 0; y < height; ++y) {
                            result.setSampleExtraAlpha(b, y, -x + width - 1, input.getSampleExtraAlpha(b, x, y));
                        }
                    }
                }
            }
        }
        return result;
    }
}

