/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.imagemanipulator.area;

import com.neptunelabs.fsiframework.concurrent.PriorityExecutor;
import com.neptunelabs.fsiframework.concurrent.PriorityExecutorCompletionService;
import com.neptunelabs.fsiframework.helpers.ExecutorPool;
import com.neptunelabs.fsiframework.helpers.ProcessingException;
import com.neptunelabs.fsiframework.logging.FSILogger;
import com.neptunelabs.imagemanipulator.utils.EffectUtils;
import com.neptunelabs.imagereader.image.FSIImage;
import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public final class SimpleBorder
extends EffectUtils {
    public SimpleBorder(FSILogger logger, ExecutorPool executorPool, int priority) {
        super(logger, executorPool, priority);
    }

    public FSIImage transform(FSIImage image, int color, int borderWidth, boolean keepInput) throws ProcessingException {
        FSIImage newImage = image.createCompatibleImage();
        int threads = this.calcThreads(image);
        PriorityExecutorCompletionService completionService = new PriorityExecutorCompletionService(this.executorPool.getExecutorService(ExecutorPool.Type.RENDERER_CPU), threads);
        ArrayList futures = new ArrayList(threads);
        int[][] yRanges = SimpleBorder.calcThreadImageRanges(image.getHeight(), threads);
        boolean error = false;
        for (int t = 0; t < threads; ++t) {
            int[] yRange = yRanges[t];
            SBorderWorkerThread thread = new SBorderWorkerThread(image, newImage.createSlice(), color, borderWidth, yRange[0], yRange[1]);
            futures.add(completionService.submit(thread));
        }
        try {
            for (int c = 0; c < completionService.count(); ++c) {
                completionService.take().get();
            }
        }
        catch (InterruptedException c) {
        }
        catch (ExecutionException e) {
            throw new ProcessingException(e);
        }
        finally {
            for (Future future : futures) {
                future.cancel(true);
            }
            if (error) {
                newImage.dispose();
            }
        }
        if (!keepInput) {
            image.dispose();
        }
        return newImage;
    }

    private class SBorderWorkerThread
    implements Runnable,
    PriorityExecutor.Important {
        private final int from;
        private final int to;
        private final FSIImage src;
        private final FSIImage target;
        private final int color;
        private final int borderWidth;

        public SBorderWorkerThread(FSIImage src, FSIImage target, int color, int borderWidth, int from, int to) {
            this.from = from;
            this.to = to;
            this.src = src;
            this.target = target;
            this.color = color;
            this.borderWidth = borderWidth;
        }

        @Override
        public void run() {
            int height = this.target.getHeight();
            int width = this.target.getWidth();
            boolean fillTotal = false;
            for (int y = this.from; y <= this.to; ++y) {
                fillTotal = y < this.borderWidth ? true : y >= height - this.borderWidth;
                for (int x = 0; x < width; ++x) {
                    int argb = x < this.borderWidth || x >= width - this.borderWidth || fillTotal ? this.color : this.src.getSample(x, y);
                    this.target.setSample(x, y, argb);
                }
            }
        }

        @Override
        public int getPriority() {
            return SimpleBorder.this.priority;
        }
    }
}

