/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.imagemanipulator.area.perspective;

import com.neptunelabs.imagemanipulator.utils.EffectThreadAbstract;
import com.neptunelabs.imagereader.converter.FastMath;

final class PDWorkerBicubic
extends EffectThreadAbstract {
    private float m0;
    private float m1;
    private float m2;
    private float m3;
    private float m4;
    private float m5;
    private float m6;
    private float m7;
    private float m8;

    public PDWorkerBicubic(int priority, int fromY, int toY) {
        super(priority, fromY, toY);
    }

    public void setOptions(float[] matrix) {
        this.m0 = matrix[0];
        this.m1 = matrix[1];
        this.m2 = matrix[2];
        this.m3 = matrix[3];
        this.m4 = matrix[4];
        this.m5 = matrix[5];
        this.m6 = matrix[6];
        this.m7 = matrix[7];
        this.m8 = matrix[8];
    }

    @Override
    public void run() {
        double[] inargb = new double[4];
        double cub1 = 0.0;
        double cub2 = 0.0;
        double a = -1.0;
        int newWidth = this.newImage.getWidth();
        for (int y = this.fromY; y <= this.toY; ++y) {
            float y1 = this.m1 * (float)y;
            float y4 = this.m4 * (float)y;
            float y7 = this.m7 * (float)y;
            for (int x = 0; x < newWidth; ++x) {
                float[] transformed = this.transformInverseFast(this.baseWidth, this.baseHeight, x, y1, y4, y7);
                int x0 = FastMath.floor(transformed[0]);
                int y0 = FastMath.floor(transformed[1]);
                double[] q = new double[4];
                for (int j = 0; j < 4; ++j) {
                    int v = y0 - 1 + j;
                    double[] p = new double[4];
                    for (int i = 0; i < 4; ++i) {
                        int c;
                        int u = x0 - 1 + i;
                        inargb = PDWorkerBicubic.argbToDouble1(this.getPixel(u, v));
                        cub1 = PDWorkerBicubic.cubic(transformed[0] - (float)u, -1.0);
                        for (c = 1; c < 4; ++c) {
                            inargb[c] = inargb[c] * inargb[0];
                        }
                        for (c = 0; c < 4; ++c) {
                            int n = c;
                            p[n] = p[n] + inargb[c] * cub1;
                        }
                    }
                    cub2 = PDWorkerBicubic.cubic(transformed[1] - (float)v, -1.0);
                    for (int c = 0; c < 4; ++c) {
                        int n = c;
                        q[n] = q[n] + p[c] * cub2;
                    }
                }
                if (q[0] > 0.0) {
                    q[1] = q[1] / q[0];
                    q[2] = q[2] / q[0];
                    q[3] = q[3] / q[0];
                }
                int argb = PDWorkerBicubic.double1ToARGB(q);
                this.newImage.setSample(x, y, argb);
            }
        }
    }

    private float[] transformInverseFast(int width, int height, int x, float y1, float y4, float y7) {
        float[] result = new float[2];
        float d2 = this.m6 * (float)x + y7 + this.m8;
        result[0] = (float)width * (this.m0 * (float)x + y1 + this.m2) / d2;
        result[1] = (float)height * (this.m3 * (float)x + y4 + this.m5) / d2;
        return result;
    }

    private int getPixel(int x, int y) {
        boolean ae = false;
        if (x < 0) {
            x = 0;
            ae = true;
        } else if (x >= this.baseWidth) {
            x = this.baseImage.getWidth() - 1;
            ae = true;
        }
        if (y < 0) {
            y = 0;
            ae = true;
        } else if (y >= this.baseHeight) {
            y = this.baseImage.getHeight() - 1;
            ae = true;
        }
        int result = ae ? this.baseImage.getSample(x, y) & 0xFFFFFF : this.baseImage.getSample(x, y);
        return result;
    }

    private static double cubic(double r, double a) {
        if (r < 0.0) {
            r = -r;
        }
        double w = r < 1.0 ? (a + 2.0) * r * r * r - (a + 3.0) * r * r + 1.0 : (r < 2.0 ? a * r * r * r - 5.0 * a * r * r + 8.0 * a * r - 4.0 * a : 0.0);
        return w;
    }
}

