/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.imagemanipulator.area.perspective;

import com.neptunelabs.imagemanipulator.utils.EffectThreadAbstract;
import com.neptunelabs.imagereader.converter.FastMath;

final class PDWorkerBilinear
extends EffectThreadAbstract {
    private float[] matrix;

    public PDWorkerBilinear(int priority, int fromY, int toY) {
        super(priority, fromY, toY);
    }

    public void setOptions(float[] matrix) {
        this.matrix = matrix;
    }

    @Override
    public void run() {
        int outWidth = this.newImage.getWidth();
        int[] outPixels = new int[outWidth];
        float m0 = this.matrix[0];
        float m1 = this.matrix[1];
        float m2 = this.matrix[2];
        float m3 = this.matrix[3];
        float m4 = this.matrix[4];
        float m5 = this.matrix[5];
        float m6 = this.matrix[6];
        float m7 = this.matrix[7];
        float m8 = this.matrix[8];
        int iw = this.baseWidth;
        int ih = this.baseHeight;
        float[] transformed = new float[2];
        for (int y = this.fromY; y <= this.toY; ++y) {
            float y1 = m1 * (float)y;
            float y4 = m4 * (float)y;
            float y7 = m7 * (float)y;
            for (int x = 0; x < outWidth; ++x) {
                PDWorkerBilinear.transformInverseFast(transformed, iw, ih, x, y1, y4, y7, m0, m2, m3, m5, m6, m8);
                int srcX = FastMath.floor(transformed[0]);
                int srcY = FastMath.floor(transformed[1]);
                float xWeight = transformed[0] - (float)srcX;
                float yWeight = transformed[1] - (float)srcY;
                int nw = this.getPixel(srcX, srcY);
                int ne = this.getPixel(srcX + 1, srcY);
                int sw = this.getPixel(srcX, srcY + 1);
                int se = this.getPixel(srcX + 1, srcY + 1);
                outPixels[x] = PDWorkerBilinear.bilinearInterpolate(xWeight, yWeight, nw, ne, sw, se);
            }
            this.newImage.setSamples((long)(y * outWidth), outPixels);
        }
    }

    private static void transformInverseFast(float[] result, int width, int height, int x, float y1, float y4, float y7, float m0, float m2, float m3, float m5, float m6, float m8) {
        float d2 = m6 * (float)x + y7 + m8;
        result[0] = (float)width * (m0 * (float)x + y1 + m2) / d2;
        result[1] = (float)height * (m3 * (float)x + y4 + m5) / d2;
    }

    private int getPixel(int x, int y) {
        boolean ae = false;
        if (x < 0) {
            x = 0;
            ae = true;
        } else if (x >= this.baseWidth) {
            x = this.baseWidth - 1;
            ae = true;
        }
        if (y < 0) {
            y = 0;
            ae = true;
        } else if (y >= this.baseHeight) {
            y = this.baseHeight - 1;
            ae = true;
        }
        int result = ae ? this.baseImage.getSample(x, y) & 0xFFFFFF : this.baseImage.getSample(x, y);
        return result;
    }

    private static int bilinearInterpolate(float x, float y, int nw, int ne, int sw, int se) {
        float cx = 1.0f - x;
        float cy = 1.0f - y;
        int nwa = nw >> 24 & 0xFF;
        int nwr = (nw >> 16 & 0xFF) * nwa;
        int nwg = (nw >> 8 & 0xFF) * nwa;
        int nwb = (nw & 0xFF) * nwa;
        int nea = ne >> 24 & 0xFF;
        int ner = (ne >> 16 & 0xFF) * nea;
        int neg = (ne >> 8 & 0xFF) * nea;
        int neb = (ne & 0xFF) * nea;
        int swa = sw >> 24 & 0xFF;
        int swr = (sw >> 16 & 0xFF) * swa;
        int swg = (sw >> 8 & 0xFF) * swa;
        int swb = (sw & 0xFF) * swa;
        int sea = se >> 24 & 0xFF;
        int ser = (se >> 16 & 0xFF) * sea;
        int seg = (se >> 8 & 0xFF) * sea;
        int seb = (se & 0xFF) * sea;
        float mx0 = cx * (float)nwa + x * (float)nea;
        float mx1 = cx * (float)swa + x * (float)sea;
        int a = PDWorkerBilinear.clampFT255(cy * mx0 + y * mx1);
        mx0 = cx * (float)nwr + x * (float)ner;
        mx1 = cx * (float)swr + x * (float)ser;
        int r = PDWorkerBilinear.clampFT255((cy * mx0 + y * mx1) / (float)a);
        mx0 = cx * (float)nwg + x * (float)neg;
        mx1 = cx * (float)swg + x * (float)seg;
        int g = PDWorkerBilinear.clampFT255((cy * mx0 + y * mx1) / (float)a);
        mx0 = cx * (float)nwb + x * (float)neb;
        mx1 = cx * (float)swb + x * (float)seb;
        int b = PDWorkerBilinear.clampFT255((cy * mx0 + y * mx1) / (float)a);
        return a << 24 | r << 16 | g << 8 | b;
    }
}

