/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.imagemanipulator.area.perspective;

import com.neptunelabs.imagemanipulator.utils.EffectThreadAbstract;
import com.neptunelabs.imagereader.converter.FastMath;

final class PDWorkerNearestNeighbor
extends EffectThreadAbstract {
    private float m0;
    private float m1;
    private float m2;
    private float m3;
    private float m4;
    private float m5;
    private float m6;
    private float m7;
    private float m8;

    public PDWorkerNearestNeighbor(int priority, int fromY, int toY) {
        super(priority, fromY, toY);
    }

    public void setOptions(float[] matrix) {
        this.m0 = matrix[0];
        this.m1 = matrix[1];
        this.m2 = matrix[2];
        this.m3 = matrix[3];
        this.m4 = matrix[4];
        this.m5 = matrix[5];
        this.m6 = matrix[6];
        this.m7 = matrix[7];
        this.m8 = matrix[8];
    }

    @Override
    public void run() {
        int newWidth = this.newImage.getWidth();
        for (int y = this.fromY; y <= this.toY; ++y) {
            float y1 = this.m1 * (float)y;
            float y4 = this.m4 * (float)y;
            float y7 = this.m7 * (float)y;
            for (int x = 0; x < newWidth; ++x) {
                float[] transformed = this.transformInverseFast(this.baseWidth, this.baseHeight, x, y1, y4, y7);
                int srcX = FastMath.floor(transformed[0]);
                int srcY = FastMath.floor(transformed[1]);
                this.newImage.setSample(x, y, this.getPixel(srcX, srcY));
            }
        }
    }

    private float[] transformInverseFast(int width, int height, int x, float y1, float y4, float y7) {
        float[] result = new float[2];
        float d2 = this.m6 * (float)x + y7 + this.m8;
        result[0] = (float)width * (this.m0 * (float)x + y1 + this.m2) / d2;
        result[1] = (float)height * (this.m3 * (float)x + y4 + this.m5) / d2;
        return result;
    }

    private int getPixel(int x, int y) {
        boolean ae = false;
        if (x < 0) {
            x = 0;
            ae = true;
        } else if (x >= this.baseWidth) {
            x = this.baseImage.getWidth() - 1;
            ae = true;
        }
        if (y < 0) {
            y = 0;
            ae = true;
        } else if (y >= this.baseHeight) {
            y = this.baseImage.getHeight() - 1;
            ae = true;
        }
        int result = ae ? this.baseImage.getSample(x, y) & 0xFFFFFF : this.baseImage.getSample(x, y);
        return result;
    }
}

