/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.imagemanipulator.area.perspective;

import com.neptunelabs.fsiframework.concurrent.PriorityExecutorCompletionService;
import com.neptunelabs.fsiframework.helpers.ExecutorPool;
import com.neptunelabs.fsiframework.helpers.ProcessingException;
import com.neptunelabs.fsiframework.logging.FSILogger;
import com.neptunelabs.imagemanipulator.area.perspective.PDWorkerBicubic;
import com.neptunelabs.imagemanipulator.area.perspective.PDWorkerBilinear;
import com.neptunelabs.imagemanipulator.area.perspective.PDWorkerNearestNeighbor;
import com.neptunelabs.imagemanipulator.utils.EffectUtils;
import com.neptunelabs.imagemanipulator.utils.ImageManipulatorException;
import com.neptunelabs.imagereader.image.FSIImage;
import com.neptunelabs.imagereader.image.FSIImageLimited;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public class PerspectiveDistortion
extends EffectUtils {
    public PerspectiveDistortion(FSILogger logger, ExecutorPool executorPool, int priority) {
        super(logger, executorPool, priority);
    }

    public FSIImage transform(FSIImage input, FILTER filter, Point2D.Float topleft, Point2D.Float topright, Point2D.Float bottomright, Point2D.Float bottomleft, boolean keepInput) throws ImageManipulatorException, ProcessingException {
        int width = input.getWidth();
        int height = input.getHeight();
        Point abstopleft = new Point();
        abstopleft.x = (int)(topleft.x * (float)width);
        abstopleft.y = (int)(topleft.y * (float)height);
        Point abstopright = new Point();
        abstopright.x = (int)(topright.x * (float)width);
        abstopright.y = (int)(topright.y * (float)height);
        Point absbottomright = new Point();
        absbottomright.x = (int)(bottomright.x * (float)width);
        absbottomright.y = (int)(bottomright.y * (float)height);
        Point absbottomleft = new Point();
        absbottomleft.x = (int)(bottomleft.x * (float)width);
        absbottomleft.y = (int)(bottomleft.y * (float)height);
        return this.transform(input, filter, abstopleft, abstopright, absbottomright, absbottomleft, keepInput);
    }

    public FSIImage transform(FSIImage input, FILTER filter, Point topleft, Point topright, Point bottomright, Point bottomleft, boolean keepInput) throws ImageManipulatorException, ProcessingException {
        float[] matrix = PerspectiveDistortion.getMatrix(topleft, topright, bottomright, bottomleft);
        input.addAlpha();
        FSIImageLimited target = ((FSIImageLimited)input).createCompatibleAlphaImage();
        int threads = this.calcThreads(input);
        PriorityExecutorCompletionService completionService = new PriorityExecutorCompletionService(this.executorPool.getExecutorService(ExecutorPool.Type.RENDERER_CPU), threads);
        ArrayList<Future<Object>> futures = new ArrayList<Future<Object>>(threads);
        int[][] yRanges = PerspectiveDistortion.calcThreadImageRanges(input.getHeight(), threads);
        switch (filter) {
            case NEAREST: {
                int[] yRange;
                int t;
                for (t = 0; t < threads; ++t) {
                    yRange = yRanges[t];
                    PDWorkerNearestNeighbor pDWorkerNearestNeighbor = new PDWorkerNearestNeighbor(this.priority, yRange[0], yRange[1]);
                    pDWorkerNearestNeighbor.setOptions(matrix);
                    pDWorkerNearestNeighbor.setImages(input, target);
                    futures.add(completionService.submit(pDWorkerNearestNeighbor, null));
                }
                break;
            }
            case BILINEAR: {
                int[] yRange;
                int t;
                for (t = 0; t < threads; ++t) {
                    yRange = yRanges[t];
                    PDWorkerBilinear pDWorkerBilinear = new PDWorkerBilinear(this.priority, yRange[0], yRange[1]);
                    pDWorkerBilinear.setOptions(matrix);
                    pDWorkerBilinear.setImages(input, target);
                    futures.add(completionService.submit(pDWorkerBilinear, null));
                }
                break;
            }
            default: {
                int[] yRange;
                int t;
                for (t = 0; t < threads; ++t) {
                    yRange = yRanges[t];
                    PDWorkerBicubic pDWorkerBicubic = new PDWorkerBicubic(this.priority, yRange[0], yRange[1]);
                    pDWorkerBicubic.setOptions(matrix);
                    pDWorkerBicubic.setImages(input, target);
                    futures.add(completionService.submit(pDWorkerBicubic, null));
                }
            }
        }
        boolean returnvalue = true;
        try {
            for (int t = 0; t < threads; ++t) {
                completionService.take().get();
            }
        }
        catch (InterruptedException e) {
            returnvalue = false;
        }
        catch (ExecutionException e) {
            returnvalue = false;
            this.logger.logException(e, 3800, e.getLocalizedMessage());
            throw new ProcessingException(e.getCause());
        }
        finally {
            for (Future future : futures) {
                future.cancel(true);
            }
            if (!returnvalue) {
                target.dispose();
            }
        }
        if (!keepInput) {
            input.dispose();
        }
        return target;
    }

    private static float[] getMatrix(Point2D topleft, Point2D topright, Point2D bottomright, Point2D bottomleft) {
        float a13;
        float a23;
        float a32;
        float a22;
        float a12;
        float a31;
        float a21;
        float a11;
        float x0 = (float)topleft.getX();
        float y0 = (float)topleft.getY();
        float x1 = (float)topright.getX();
        float y1 = (float)topright.getY();
        float x2 = (float)bottomright.getX();
        float y2 = (float)bottomright.getY();
        float x3 = (float)bottomleft.getX();
        float y3 = (float)bottomleft.getY();
        float dx1 = x1 - x2;
        float dy1 = y1 - y2;
        float dx2 = x3 - x2;
        float dy2 = y3 - y2;
        float dx3 = x0 - x1 + x2 - x3;
        float dy3 = y0 - y1 + y2 - y3;
        if (dx3 == 0.0f && dy3 == 0.0f) {
            a11 = x1 - x0;
            a21 = x2 - x1;
            a31 = x0;
            a12 = y1 - y0;
            a22 = y2 - y1;
            a32 = y0;
            a23 = 0.0f;
            a13 = 0.0f;
        } else {
            a13 = (dx3 * dy2 - dx2 * dy3) / (dx1 * dy2 - dy1 * dx2);
            a23 = (dx1 * dy3 - dy1 * dx3) / (dx1 * dy2 - dy1 * dx2);
            a11 = x1 - x0 + a13 * x1;
            a21 = x3 - x0 + a23 * x3;
            a31 = x0;
            a12 = y1 - y0 + a13 * y1;
            a22 = y3 - y0 + a23 * y3;
            a32 = y0;
        }
        float A = a22 - a32 * a23;
        float B = a31 * a23 - a21;
        float C = a21 * a32 - a31 * a22;
        float D = a32 * a13 - a12;
        float E = a11 - a31 * a13;
        float F = a31 * a12 - a11 * a32;
        float G = a12 * a23 - a22 * a13;
        float H = a21 * a13 - a11 * a23;
        float I = a11 * a22 - a21 * a12;
        return new float[]{A, B, C, D, E, F, G, H, I};
    }

    public static enum FILTER {
        NEAREST,
        BILINEAR,
        BICUBIC;

    }
}

