/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.imagemanipulator.area.scale;

import com.neptunelabs.fsiframework.concurrent.PriorityExecutor;
import com.neptunelabs.imagereader.image.FSIImage;
import com.neptunelabs.imagereader.image.FSIImageException;

final class UniNearestNeighborThread
implements Runnable,
PriorityExecutor.Important {
    private final int priority;
    private final int pStart;
    private final int pStop;
    private FSIImage image;
    private FSIImage imageScaled;
    private int widthNew;
    private int heightNew;
    private int widthOrg;
    private int heightOrg;
    volatile boolean running = false;

    UniNearestNeighborThread(int priority, int pStart, int pStop) {
        this.priority = priority;
        this.pStart = pStart;
        this.pStop = pStop;
    }

    @Override
    public void run() throws FSIImageException {
        this.running = true;
        float ratX = (float)this.widthOrg / (float)this.widthNew;
        float ratY = (float)this.heightOrg / (float)this.heightNew;
        for (int y = this.pStart; y <= this.pStop && this.running; ++y) {
            int srcY = (int)(ratY * (float)y);
            for (int x = 0; x < this.widthNew; ++x) {
                int s = this.image.getSample((int)(ratX * (float)x), srcY);
                this.imageScaled.setSample(x, y, s);
            }
        }
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    void setImage(FSIImage image) {
        this.image = image;
        this.widthOrg = image.getWidth();
        this.heightOrg = image.getHeight();
    }

    void setScaledImage(FSIImage image) {
        this.imageScaled = image;
        this.widthNew = this.imageScaled.getWidth();
        this.heightNew = this.imageScaled.getHeight();
    }
}

