/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.imagemanipulator.area.scale;

import com.neptunelabs.fsiframework.concurrent.PriorityExecutorCompletionService;
import com.neptunelabs.fsiframework.helpers.ExecutorPool;
import com.neptunelabs.fsiframework.helpers.ProcessingException;
import com.neptunelabs.fsiframework.logging.FSILogger;
import com.neptunelabs.imagemanipulator.area.ConvolutionKernel1D;
import com.neptunelabs.imagemanipulator.area.Flip;
import com.neptunelabs.imagemanipulator.area.Rotate90;
import com.neptunelabs.imagemanipulator.area.scale.UniNearestNeighborThread;
import com.neptunelabs.imagemanipulator.area.scale.UniScaler1DAbstract;
import com.neptunelabs.imagemanipulator.area.scale.UniScaler1DThread;
import com.neptunelabs.imagemanipulator.area.scale.UniScaler1DThreadUnlimited;
import com.neptunelabs.imagereader.image.FSIImage;
import com.neptunelabs.imagereader.image.FSIImageUnlimited;
import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public final class UniScaler {
    private volatile boolean halted = false;
    private final FSILogger logger;
    private final ExecutorPool executorPool;

    public UniScaler(FSILogger logger, ExecutorPool executorPool) {
        this.logger = logger;
        this.executorPool = executorPool;
    }

    public UniScaler(FSILogger logger, ExecutorPool executorPool, int fsiImageLimitedThreshold) {
        this.logger = logger;
        this.executorPool = executorPool;
    }

    public FSIImage transform(int priority, ExecutorPool.Type type, Interpolation interpolation, double windowSize, FSIImage sourceImage, int newWidth, int newHeight, double kernelShiftX, double kernelShiftY, double kernelShiftW, double kernelShiftH, boolean keepInput) throws ProcessingException {
        if (this.halted) {
            return null;
        }
        int width = sourceImage.getWidth();
        int height = sourceImage.getHeight();
        ScaleDirection horizontalScaleDirection = newWidth < width ? ScaleDirection.DOWN : (newWidth > width ? ScaleDirection.UP : ScaleDirection.LEAVE);
        ScaleDirection verticalScaleDirection = newHeight < height ? ScaleDirection.DOWN : (newHeight > height ? ScaleDirection.UP : ScaleDirection.LEAVE);
        FSIImage targetImage = null;
        if (horizontalScaleDirection == ScaleDirection.LEAVE && verticalScaleDirection == ScaleDirection.LEAVE) {
            targetImage = sourceImage.createCopy();
        } else {
            boolean twoPass = false;
            twoPass = interpolation == Interpolation.LANCZOS;
            try {
                if (twoPass) {
                    Flip flip;
                    Rotate90 rotate;
                    boolean regular;
                    FSIImage imageScaledHorizontal;
                    if (horizontalScaleDirection != ScaleDirection.LEAVE) {
                        ConvolutionKernel1D kernHorizontal = ConvolutionKernel1D.buildLanczosKernel(width, newWidth, kernelShiftX, kernelShiftW, windowSize);
                        imageScaledHorizontal = sourceImage.createCompatibleImage(height, newWidth);
                        regular = false;
                        this.scaling(priority, type, sourceImage, imageScaledHorizontal, kernHorizontal, interpolation, false);
                        if (verticalScaleDirection == ScaleDirection.LEAVE) {
                            rotate = new Rotate90(this.logger, this.executorPool, priority);
                            imageScaledHorizontal = rotate.transform(imageScaledHorizontal, 90, false);
                            flip = new Flip(this.logger, this.executorPool, priority);
                            imageScaledHorizontal = flip.transform(imageScaledHorizontal, 0, false);
                        }
                    } else {
                        imageScaledHorizontal = sourceImage.createCopy();
                    }
                    if (verticalScaleDirection != ScaleDirection.LEAVE) {
                        ConvolutionKernel1D kernVertical = ConvolutionKernel1D.buildLanczosKernel(height, newHeight, kernelShiftY, kernelShiftH, windowSize);
                        targetImage = sourceImage.createCompatibleImage(newWidth, newHeight);
                        if (horizontalScaleDirection != ScaleDirection.LEAVE) {
                            regular = false;
                        } else {
                            rotate = new Rotate90(this.logger, this.executorPool, priority);
                            imageScaledHorizontal = rotate.transform(sourceImage, 90, true);
                            flip = new Flip(this.logger, this.executorPool, priority);
                            imageScaledHorizontal = flip.transform(imageScaledHorizontal, 0, false);
                            regular = false;
                        }
                        this.scaling(priority, type, imageScaledHorizontal, targetImage, kernVertical, interpolation, regular);
                    } else {
                        targetImage = imageScaledHorizontal.createCopy();
                    }
                    imageScaledHorizontal.dispose();
                } else {
                    targetImage = sourceImage.createCompatibleImage(newWidth, newHeight);
                    this.scaling(priority, type, sourceImage, targetImage, null, interpolation, true);
                }
            }
            catch (InterruptedException e) {
                if (targetImage != null) {
                    targetImage.dispose();
                }
                throw new ProcessingException(e);
            }
        }
        if (!keepInput && !sourceImage.isDisposed()) {
            sourceImage.dispose();
        }
        return targetImage;
    }

    private void scaling(int priority, ExecutorPool.Type type, FSIImage sourceImage, FSIImage targetImage, ConvolutionKernel1D kernel, Interpolation interpolation, boolean regular) throws ProcessingException, InterruptedException {
        int yRange;
        int ths;
        int threads = this.executorPool.getAvailableThreads(type);
        int th = targetImage.getHeight() < threads ? targetImage.getHeight() : threads;
        int n = ths = sourceImage.getHeight() < threads ? sourceImage.getHeight() : threads;
        if (ths < th) {
            th = ths;
        }
        PriorityExecutorCompletionService completionService = new PriorityExecutorCompletionService(this.executorPool.getExecutorService(type));
        ArrayList futures = new ArrayList();
        if (!regular) {
            yRange = (int)Math.floor(sourceImage.getHeight() / th) - 1;
        } else {
            yRange = sourceImage.getHeight() >= targetImage.getHeight() ? (int)Math.floor(targetImage.getHeight() / th) : (int)Math.floor(targetImage.getHeight() / th);
            if (yRange == 0) {
                yRange = targetImage.getHeight();
            }
        }
        int yStart = 0;
        for (int t = 0; t < th && !this.halted; ++t) {
            Runnable filterThread;
            int yStop = t + 1 < th ? yStart + yRange : (!regular ? sourceImage.getHeight() - 1 : targetImage.getHeight() - 1);
            if (interpolation == Interpolation.NEAREST) {
                filterThread = new UniNearestNeighborThread(priority, yStart, yStop);
                if (th == 1) {
                    ((UniNearestNeighborThread)filterThread).setImage(sourceImage);
                } else {
                    ((UniNearestNeighborThread)filterThread).setImage(sourceImage.createSlice());
                }
                ((UniNearestNeighborThread)filterThread).setScaledImage(targetImage.createSlice());
                futures.add(completionService.submit(filterThread));
            } else if (interpolation == Interpolation.LANCZOS) {
                if (sourceImage instanceof FSIImageUnlimited || targetImage instanceof FSIImageUnlimited) {
                    filterThread = new UniScaler1DThreadUnlimited(priority, yStart, yStop);
                    if (th == 1) {
                        ((UniScaler1DAbstract)filterThread).setImage(sourceImage);
                    } else {
                        ((UniScaler1DAbstract)filterThread).setImage(sourceImage.createSlice());
                    }
                    ((UniScaler1DAbstract)filterThread).setScaledImage(targetImage.createSlice());
                    ((UniScaler1DAbstract)filterThread).setScaleData(kernel.getShiftingMatrix(), kernel.getStartShifting());
                    futures.add(completionService.submit(filterThread));
                } else {
                    filterThread = new UniScaler1DThread(priority, yStart, yStop);
                    if (th == 1) {
                        ((UniScaler1DAbstract)filterThread).setImage(sourceImage);
                    } else {
                        ((UniScaler1DAbstract)filterThread).setImage(sourceImage.createSlice());
                    }
                    ((UniScaler1DAbstract)filterThread).setScaledImage(targetImage.createSlice());
                    ((UniScaler1DAbstract)filterThread).setScaleData(kernel.getShiftingMatrix(), kernel.getStartShifting());
                    futures.add(completionService.submit(filterThread));
                }
            }
            yStart = yStop + 1;
        }
        try {
            for (int c = 0; c < completionService.count(); ++c) {
                completionService.take().get();
            }
        }
        catch (ExecutionException e) {
            throw new ProcessingException(e.getCause());
        }
        finally {
            for (Future future : futures) {
                future.cancel(true);
            }
        }
    }

    public static enum Interpolation {
        NEAREST,
        LANCZOS;

    }

    private static enum ScaleDirection {
        UP,
        LEAVE,
        DOWN;

    }
}

