/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.imagemanipulator.area.scale;

import com.neptunelabs.fsiframework.concurrent.PriorityExecutor;
import com.neptunelabs.imagereader.image.FSIImage;
import com.neptunelabs.imagereader.image.FSIImageException;

abstract class UniScaler1DAbstract
implements Runnable,
PriorityExecutor.Important {
    protected final int priority;
    protected final int threadStart;
    protected final int threadStop;
    protected volatile boolean running = false;
    FSIImage image;
    FSIImage imageScaled;
    int widthNew;
    int heightNew;
    int widthOrg;
    int heightOrg;
    float[][] contribMatrix;
    int[] startMatrix;
    boolean isGray = false;
    boolean hasAlpha = false;

    UniScaler1DAbstract(int priority, int pStart, int pStop) {
        this.priority = priority;
        this.threadStart = pStart;
        this.threadStop = pStop;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    public void setImage(FSIImage image) {
        this.image = image;
        this.widthOrg = image.getWidth();
        this.heightOrg = image.getHeight();
        this.hasAlpha = image.hasAlpha();
    }

    public void setScaledImage(FSIImage image) {
        this.imageScaled = image;
        this.widthNew = image.getWidth();
        this.heightNew = image.getHeight();
    }

    public void setScaleData(float[][] contribMatrix, int[] startMatrix) {
        this.contribMatrix = contribMatrix;
        this.startMatrix = startMatrix;
    }

    protected static final void fillRGBARowIntBuffer(FSIImage image, int[] buffer, int width, int y, int minX) throws FSIImageException {
        int xOff = minX * -1;
        image.setPosition(0, y);
        image.getSamples(buffer, xOff, width);
        int argb0 = buffer[xOff];
        int x = minX;
        int b = 0;
        while (x < 0) {
            buffer[b] = argb0;
            ++x;
            ++b;
        }
        int argbZ = buffer[xOff + width - 1];
        int n = buffer.length;
        for (b = xOff + width; b < n; ++b) {
            buffer[b] = argbZ;
        }
    }

    protected static final void fillExtraAlphaRowBuffer(FSIImage image, int bank, byte[] buffer, int width, int y, int minX) throws FSIImageException {
        int xOff = minX * -1;
        image.setPositionExtraAlpha(bank, 0, y);
        image.getSamplesExtraAlpha(bank, buffer, xOff, width);
        byte argb0 = buffer[xOff];
        int x = minX;
        int b = 0;
        while (x < 0) {
            buffer[b] = argb0;
            ++x;
            ++b;
        }
        byte argbZ = buffer[xOff + width - 1];
        int n = buffer.length;
        for (b = xOff + width; b < n; ++b) {
            buffer[b] = argbZ;
        }
    }

    protected static final byte filterGrayByte(byte[] srcPixel, int inOffset, float[] contrib) {
        float pixelValueGray = 0.0f;
        int j = 0;
        int k = inOffset;
        int n = contrib.length;
        while (j < n) {
            pixelValueGray += (float)(srcPixel[k] & 0xFF) * contrib[j];
            ++j;
            ++k;
        }
        return (byte)UniScaler1DAbstract.clampFTInt(pixelValueGray);
    }

    protected static final int filterGrayInt(int[] srcPixel, int inOffset, float[] contrib) {
        float pixelValueGray = 0.0f;
        int j = 0;
        int k = inOffset;
        int n = contrib.length;
        while (j < n) {
            pixelValueGray += (float)(srcPixel[k] & 0xFF) * contrib[j];
            ++j;
            ++k;
        }
        return 0xFF000000 | UniScaler1DAbstract.clampFTInt(pixelValueGray);
    }

    protected static final int filterGrayAInt(int[] srcPixel, int inOffset, float[] contrib) {
        float pixelValueAlpha = 0.0f;
        float pixelValueGray = 0.0f;
        int j = 0;
        int k = inOffset;
        int n = contrib.length;
        while (j < n) {
            int argb = srcPixel[k];
            float pa = contrib[j] * ((float)(argb >> 24 & 0xFF) / 255.0f);
            pixelValueAlpha += pa;
            pixelValueGray += (float)(argb & 0xFF) * pa;
            ++j;
            ++k;
        }
        return UniScaler1DAbstract.clampFT(pixelValueAlpha) << 24 | UniScaler1DAbstract.clampFTInt(pixelValueGray /= pixelValueAlpha);
    }

    protected static final int filterRGBInt(int[] srcPixel, int inOffset, float[] contrib) {
        float pixelValueRed = 0.0f;
        float pixelValueGreen = 0.0f;
        float pixelValueBlue = 0.0f;
        int j = 0;
        int k = inOffset;
        int n = contrib.length;
        while (j < n) {
            float p = contrib[j];
            int argb = srcPixel[k];
            pixelValueRed += (float)(argb >> 16 & 0xFF) * p;
            pixelValueGreen += (float)(argb >> 8 & 0xFF) * p;
            pixelValueBlue += (float)(argb & 0xFF) * p;
            ++j;
            ++k;
        }
        return UniScaler1DAbstract.makeARGB(-16777216, pixelValueRed, pixelValueGreen, pixelValueBlue);
    }

    private static final int makeARGB(int pixelValueAlpha, float pixelValueRed, float pixelValueGreen, float pixelValueBlue) {
        return pixelValueAlpha | UniScaler1DAbstract.clampFTInt(pixelValueRed) << 16 | UniScaler1DAbstract.clampFTInt(pixelValueGreen) << 8 | UniScaler1DAbstract.clampFTInt(pixelValueBlue);
    }

    protected static final int filterRGBAInt(int[] srcPixel, int inOffset, float[] contrib) {
        float pixelValueAlpha = 0.0f;
        float pixelValueRed = 0.0f;
        float pixelValueGreen = 0.0f;
        float pixelValueBlue = 0.0f;
        int j = 0;
        int k = inOffset;
        int n = contrib.length;
        while (j < n) {
            int argb = srcPixel[k];
            float pa = contrib[j] * ((float)(argb >> 24 & 0xFF) / 255.0f);
            pixelValueAlpha += pa;
            pixelValueRed += (float)(argb >> 16 & 0xFF) * pa;
            pixelValueGreen += (float)(argb >> 8 & 0xFF) * pa;
            pixelValueBlue += (float)(argb & 0xFF) * pa;
            ++j;
            ++k;
        }
        return UniScaler1DAbstract.makeARGB(UniScaler1DAbstract.clampFT(pixelValueAlpha) << 24, pixelValueRed /= pixelValueAlpha, pixelValueGreen /= pixelValueAlpha, pixelValueBlue /= pixelValueAlpha);
    }

    protected static final int clampFTInt(float x) {
        if (x < 0.0f) {
            return 0;
        }
        if (x > 255.0f) {
            return 255;
        }
        return (int)(x + 0.5f);
    }

    protected static final int clampFT(float x) {
        if (x < 0.0f) {
            return 0;
        }
        if (x > 1.0f) {
            return 255;
        }
        return (int)(x * 255.0f + 0.5f);
    }
}

