/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.imagemanipulator.area.scale;

import com.neptunelabs.imagemanipulator.area.scale.UniScaler1DAbstract;
import com.neptunelabs.imagereader.image.FSIImageException;

final class UniScaler1DThread
extends UniScaler1DAbstract {
    UniScaler1DThread(int priority, int pStart, int pStop) {
        super(priority, pStart, pStop);
    }

    @Override
    public void run() throws FSIImageException {
        int ny;
        int nx;
        this.running = true;
        int minStart = this.startMatrix[0];
        int maxBufferSize = this.widthOrg + this.contribMatrix[0].length * 2;
        int[] bufferInt = new int[maxBufferSize];
        if (this.isGray && !this.hasAlpha) {
            for (nx = this.threadStart; nx <= this.threadStop && this.running; ++nx) {
                UniScaler1DThread.fillRGBARowIntBuffer(this.image, bufferInt, this.widthOrg, nx, minStart);
                for (ny = 0; ny < this.heightNew; ++ny) {
                    this.imageScaled.setSample(nx, ny, UniScaler1DThread.filterGrayInt(bufferInt, this.startMatrix[ny] - minStart, this.contribMatrix[ny]));
                }
            }
        } else if (this.isGray && this.hasAlpha) {
            for (nx = this.threadStart; nx <= this.threadStop && this.running; ++nx) {
                UniScaler1DThread.fillRGBARowIntBuffer(this.image, bufferInt, this.widthOrg, nx, minStart);
                for (ny = 0; ny < this.heightNew; ++ny) {
                    this.imageScaled.setSample(nx, ny, UniScaler1DThread.filterGrayAInt(bufferInt, this.startMatrix[ny] - minStart, this.contribMatrix[ny]));
                }
            }
        } else if (!this.hasAlpha) {
            for (nx = this.threadStart; nx <= this.threadStop && this.running; ++nx) {
                UniScaler1DThread.fillRGBARowIntBuffer(this.image, bufferInt, this.widthOrg, nx, minStart);
                for (ny = 0; ny < this.heightNew; ++ny) {
                    this.imageScaled.setSample(nx, ny, UniScaler1DThread.filterRGBInt(bufferInt, this.startMatrix[ny] - minStart, this.contribMatrix[ny]));
                }
            }
        } else {
            for (nx = this.threadStart; nx <= this.threadStop && this.running; ++nx) {
                UniScaler1DThread.fillRGBARowIntBuffer(this.image, bufferInt, this.widthOrg, nx, minStart);
                for (ny = 0; ny < this.heightNew; ++ny) {
                    this.imageScaled.setSample(nx, ny, UniScaler1DThread.filterRGBAInt(bufferInt, this.startMatrix[ny] - minStart, this.contribMatrix[ny]));
                }
            }
        }
        if (this.image.getExtraAlphaCount() > 0) {
            byte[] bufferByte = new byte[maxBufferSize];
            for (int b = 0; b < this.image.getExtraAlphaCount() && this.running; ++b) {
                for (int nx2 = this.threadStart; nx2 <= this.threadStop && this.running; ++nx2) {
                    UniScaler1DThread.fillExtraAlphaRowBuffer(this.image, b, bufferByte, this.widthOrg, nx2, minStart);
                    for (int ny2 = 0; ny2 < this.heightNew; ++ny2) {
                        this.imageScaled.setSampleExtraAlpha(b, nx2, ny2, UniScaler1DThread.filterGrayByte(bufferByte, this.startMatrix[ny2] - minStart, this.contribMatrix[ny2]));
                    }
                }
            }
        }
    }
}

