/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.imagemanipulator.area.scale;

import com.neptunelabs.imagemanipulator.area.scale.UniScaler1DAbstract;
import com.neptunelabs.imagereader.image.FSIImageException;

final class UniScaler1DThreadUnlimited
extends UniScaler1DAbstract {
    UniScaler1DThreadUnlimited(int priority, int pStart, int pStop) {
        super(priority, pStart, pStop);
    }

    @Override
    public void run() throws FSIImageException {
        int ny;
        int nx;
        this.running = true;
        int minStart = this.startMatrix[0];
        int maxBufferSize = this.widthOrg + this.contribMatrix[0].length * 2;
        int[] bufferInt = new int[maxBufferSize];
        byte[] bufferByte = new byte[maxBufferSize];
        int columnBufferWidth = 100;
        int[] columnBuffer = new int[this.heightNew * 100];
        int cbPos = 0;
        int col = 0;
        if (this.isGray && !this.hasAlpha) {
            for (nx = this.threadStart; nx <= this.threadStop && this.running; ++nx) {
                cbPos = col;
                UniScaler1DThreadUnlimited.fillRGBARowIntBuffer(this.image, bufferInt, this.widthOrg, nx, minStart);
                ny = 0;
                while (ny < this.heightNew) {
                    columnBuffer[cbPos] = UniScaler1DThreadUnlimited.filterGrayInt(bufferInt, this.startMatrix[ny] - minStart, this.contribMatrix[ny]);
                    ++ny;
                    cbPos += 100;
                }
                if (++col != 100 && nx != this.threadStop) continue;
                this.writeColumnBuffer(col, nx, 100, columnBuffer);
                col = 0;
                cbPos = 0;
            }
        } else if (this.isGray && this.hasAlpha) {
            for (nx = this.threadStart; nx <= this.threadStop && this.running; ++nx) {
                cbPos = col;
                UniScaler1DThreadUnlimited.fillRGBARowIntBuffer(this.image, bufferInt, this.widthOrg, nx, minStart);
                ny = 0;
                while (ny < this.heightNew) {
                    columnBuffer[cbPos] = UniScaler1DThreadUnlimited.filterGrayAInt(bufferInt, this.startMatrix[ny] - minStart, this.contribMatrix[ny]);
                    ++ny;
                    cbPos += 100;
                }
                if (++col != 100 && nx != this.threadStop) continue;
                this.writeColumnBuffer(col, nx, 100, columnBuffer);
                col = 0;
                cbPos = 0;
            }
        } else if (!this.hasAlpha) {
            for (nx = this.threadStart; nx <= this.threadStop && this.running; ++nx) {
                cbPos = col;
                UniScaler1DThreadUnlimited.fillRGBARowIntBuffer(this.image, bufferInt, this.widthOrg, nx, minStart);
                ny = 0;
                while (ny < this.heightNew) {
                    columnBuffer[cbPos] = UniScaler1DThreadUnlimited.filterRGBInt(bufferInt, this.startMatrix[ny] - minStart, this.contribMatrix[ny]);
                    ++ny;
                    cbPos += 100;
                }
                if (++col != 100 && nx != this.threadStop) continue;
                this.writeColumnBuffer(col, nx, 100, columnBuffer);
                col = 0;
                cbPos = 0;
            }
        } else {
            for (nx = this.threadStart; nx <= this.threadStop && this.running; ++nx) {
                cbPos = col;
                UniScaler1DThreadUnlimited.fillRGBARowIntBuffer(this.image, bufferInt, this.widthOrg, nx, minStart);
                ny = 0;
                while (ny < this.heightNew) {
                    columnBuffer[cbPos] = UniScaler1DThreadUnlimited.filterRGBAInt(bufferInt, this.startMatrix[ny] - minStart, this.contribMatrix[ny]);
                    ++ny;
                    cbPos += 100;
                }
                if (++col != 100 && nx != this.threadStop) continue;
                this.writeColumnBuffer(col, nx, 100, columnBuffer);
                col = 0;
                cbPos = 0;
            }
        }
        if (this.image.getExtraAlphaCount() > 0) {
            for (int b = 0; b < this.image.getExtraAlphaCount() && this.running; ++b) {
                for (int nx2 = this.threadStart; nx2 <= this.threadStop && this.running; ++nx2) {
                    UniScaler1DThreadUnlimited.fillExtraAlphaRowBuffer(this.image, b, bufferByte, this.widthOrg, nx2, minStart);
                    for (int ny2 = 0; ny2 < this.heightNew; ++ny2) {
                        this.imageScaled.setSampleExtraAlpha(b, nx2, ny2, UniScaler1DThreadUnlimited.filterGrayByte(bufferByte, this.startMatrix[ny2] - minStart, this.contribMatrix[ny2]));
                    }
                }
            }
        }
    }

    private void writeColumnBuffer(int col, int nx, int columnBufferWidth, int[] columnBuffer) {
        for (int ny = 0; ny < this.heightNew; ++ny) {
            for (int cx = 0; cx < col; ++cx) {
                int cnx = nx - col + 1 + cx;
                int cpp = ny * columnBufferWidth + cx;
                this.imageScaled.setSample(cnx, ny, columnBuffer[cpp]);
            }
        }
    }
}

