/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.imagemanipulator.color;

import com.neptunelabs.imagemanipulator.color.ColorOperatorImpl;
import com.neptunelabs.imagemanipulator.utils.BaseImageUtils;
import com.neptunelabs.imagemanipulator.utils.ImageManipulatorException;

public final class Brightness
extends ColorOperatorImpl {
    private final float brightness;
    private final float contrast;
    private static final double PI4 = 0.7853981633974483;

    public Brightness(int brightness, int contrast) throws ImageManipulatorException {
        if (brightness < -100) {
            brightness = -100;
        } else if (brightness > 100) {
            brightness = 100;
        }
        if (contrast < -100) {
            contrast = -100;
        } else if (contrast > 100) {
            contrast = 100;
        }
        this.brightness = (float)brightness / 100.0f;
        this.contrast = (float)Math.tan((double)((float)contrast / 100.0f + 1.0f) * 0.7853981633974483);
    }

    @Override
    public final int transform(int argb, int pos) {
        int alpha = argb >>> 24 & 0xFF;
        float r = argb >> 16 & 0xFF;
        float g = argb >> 8 & 0xFF;
        float b = argb & 0xFF;
        r = (r / 255.0f - 0.5f) * this.contrast + this.brightness + 0.5f;
        g = (g / 255.0f - 0.5f) * this.contrast + this.brightness + 0.5f;
        b = (b / 255.0f - 0.5f) * this.contrast + this.brightness + 0.5f;
        return alpha << 24 | BaseImageUtils.clampFT255(r * 255.0f) << 16 | BaseImageUtils.clampFT255(g * 255.0f) << 8 | BaseImageUtils.clampFT255(b * 255.0f);
    }
}

